
------------------------------------------------ Create Table
CREATE TABLE Cliente ( 
    ClienteID   INT   		   NOT NULL,
    Empresa  	VARCHAR( 40 )  NOT NULL,
    Endereco    VARCHAR( 60 ),
    Cidade      VARCHAR( 15 ),
    Estado      VARCHAR( 15 ),
    CEP   		VARCHAR( 10 ),
    Pais        VARCHAR( 15 ),
    Fone        VARCHAR( 24 ),
    CONSTRAINT ClientePK PRIMARY KEY (ClienteID) 
);


CREATE TABLE Fornecedor ( 
    FornecedorID   	INT   			NOT NULL,
    Nome  			VARCHAR( 40 )  	NOT NULL,
    Endereco   		VARCHAR( 60 ),
    CONSTRAINT FornecedorPK PRIMARY KEY (FornecedorID) 
);

CREATE TABLE Produto ( 
    ProdutoID   	INT   			NOT NULL,
    FornecedorID    INT   			NOT NULL,
    Descricao  		VARCHAR( 40 )  	NOT NULL,
    PrecoUnitario   REAL 			NOT NULL  CHECK(PrecoUnitario>=0),
    
    CONSTRAINT ProdutoPK 		PRIMARY KEY (ProdutoID),
    
    CONSTRAINT FornecProdutoFK 	FOREIGN KEY (FornecedorID) 
    							REFERENCES Fornecedor(FornecedorID) 
    							ON DELETE CASCADE 
    							ON UPDATE CASCADE   
);

CREATE TABLE Vendedor ( 
    VendedorID  INT   			NOT NULL,
    Nome  		VARCHAR( 40 )  	NOT NULL,
    
    PRIMARY KEY ( VendedorID ) 
);

CREATE TABLE Pedido ( 
    PedidoID   	INT 			NOT NULL,
    VendedorID  INT 			NOT NULL,
    ClienteID  	INT  			NOT NULL,
    ProdutoID  	INT 			NOT NULL,
    Quantidade  INT 			NOT NULL 	DEFAULT 1  CHECK(Quantidade>0),
    
    PRIMARY KEY ( PedidoID ),
    
    CONSTRAINT PedidoVendedorFK FOREIGN KEY (VendedorID) REFERENCES Vendedor(VendedorID) 
    							ON DELETE CASCADE 
    							ON UPDATE CASCADE,
    							
    CONSTRAINT PedidoClienteFK FOREIGN KEY (ClienteID) REFERENCES Cliente(ClienteID) 
    							ON DELETE CASCADE 
    							ON UPDATE CASCADE,
    							
    CONSTRAINT PedidoProdutoFK FOREIGN KEY (ProdutoID) REFERENCES Produto(ProdutoID) 
    							ON DELETE CASCADE 
    							ON UPDATE CASCADE   
);

------------------------------------------------ Insert Table

INSERT INTO Cliente Values ( 1, 'ACM', 'Rua das Flores, 10', 'Sao Paulo', 'SP', 
							'1222000', 'Brasil', '112233445566');
INSERT INTO Cliente Values ( 2, 'VW', 'Rua do Comercio, 47', 'Sao Paulo', 'SP', 
							'1222010', 'Brasil', '11298735566');
INSERT INTO Cliente Values ( 3, 'GM', 'Via Dutra, 1000', 'Sao Jose dos Campos', 'SP', 
							'1222560', 'Brasil', '122239876566');
INSERT INTO Cliente Values ( 4, 'TEX', 'AV Brasil, 1210', 'Rio de Janeiro', 'RJ', 
							'348890', 'Brasil', '212134567');

--OBS: temos que alterar o tipo da coluna Cidade!


INSERT INTO Vendedor Values ( 1, 'Jose Marcio');
INSERT INTO Vendedor Values ( 2, 'Luis Claudio');
INSERT INTO Vendedor Values ( 3, 'Andre Carlos');

INSERT INTO Fornecedor Values ( 1, 'Ferragens Santa Lucia', 
								'Rua Catalao, 20, Goiania, GO');
INSERT INTO Fornecedor Values ( 2, 'Borracharia Campos', 
								'Rua dos Ipes 1235, Presidente Prudente, SP');
INSERT INTO Fornecedor Values ( 3, 'Tintas Brasil', 
								'Avenida dos Guararapes 44, Paulinia, SP');

INSERT INTO Produto Values ( 1, 2, 'Roda', 500.00);
INSERT INTO Produto Values ( 2, 1, 'Mola', 234.00);
INSERT INTO Produto Values ( 3, 1, 'Porca', 11.00);
INSERT INTO Produto Values ( 4, 1, 'Parafuso', 5.30);
INSERT INTO Produto Values ( 5, 2, 'Prego', 1.20);
INSERT INTO Produto Values ( 6, 3, 'Tinta', 234.00);

INSERT INTO Pedido Values ( 1, 2, 4, 2, 450);
INSERT INTO Pedido Values ( 2, 1, 2, 1, 123);
INSERT INTO Pedido Values ( 3, 2, 1, 2, 60);
INSERT INTO Pedido Values ( 4, 3, 2, 2, 121);
INSERT INTO Pedido Values ( 5, 3, 3, 6, 65);
INSERT INTO Pedido Values ( 6, 1, 3, 5, 36);
INSERT INTO Pedido Values ( 7, 2, 1, 5, 140);
INSERT INTO Pedido Values ( 8, 3, 4, 1, 200);
INSERT INTO Pedido Values ( 9, 3, 2, 3, 67);
INSERT INTO Pedido Values ( 10, 1, 2, 3, 89);


CREATE TABLE Cliente2 ( 
    ClienteID   INT   		   NOT NULL,
    Empresa  	VARCHAR( 40 )  NOT NULL,
    Endereco    VARCHAR( 60 ),
    Cidade      VARCHAR( 50 ),
    Estado      VARCHAR( 15 ),
    CEP   		VARCHAR( 10 ),
    Pais        VARCHAR( 15 ),
    Fone        VARCHAR( 24 ),
    CONSTRAINT Cliente2PK PRIMARY KEY (ClienteID) 
);


INSERT INTO Cliente2 (SELECT * FROM Cliente);


------------------------------------------------ Catalogo

SELECT * FROM information_schema.tables

SELECT * FROM information_schema.columns

SELECT * FROM information_schema.views

SELECT * FROM information_schema.triggers

...


------------------------------------------------ Alter Table

ALTER TABLE Cliente ADD CPF VARCHAR( 14 ) NOT NULL DEFAULT 0000000 

ALTER TABLE Cliente ADD COLUMN CPF2 VARCHAR( 14 ) NOT NULL DEFAULT 0000000 

ALTER TABLE Cliente DROP COLUMN CPF2 CASCADE

ALTER TABLE Cliente ALTER COLUMN CPF DROP NOT NULL

ALTER TABLE Cliente ALTER COLUMN CPF TYPE VARCHAR( 150 )








