CREATE TABLE Cliente ( 
    ClienteID   VARCHAR( 5 )   NOT NULL,
    Empresa  	VARCHAR( 40 )  NOT NULL,
    Endereco    VARCHAR( 60 ),
    Cidade      VARCHAR( 15 ),
    Estado      VARCHAR( 15 ),
    CEP   		VARCHAR( 10 ),
    Pais        VARCHAR( 15 ),
    Fone        VARCHAR( 24 ),
    PRIMARY KEY ( ClienteID ) 
);

CREATE TABLE Fornecedor ( 
    FornecedorID   	VARCHAR( 5 )   NOT NULL,
    Nome  			VARCHAR( 40 )  NOT NULL,
    Endereco   		VARCHAR( 60 ),
    PRIMARY KEY ( FornecedorID ) 
);

CREATE TABLE Vendedor ( 
    VendedorID  VARCHAR( 5 )   NOT NULL,
    Nome  		VARCHAR( 40 )  NOT NULL,
    PRIMARY KEY ( VendedorID ) 
);

CREATE TABLE Produto ( 
    ProdutoID   	VARCHAR( 5 )   NOT NULL,
    FornecedorID    VARCHAR( 5 )   NOT NULL,
    Descricao  		VARCHAR( 40 )  NOT NULL,
    PrecoUnitario   REAL NOT NULL,
    PRIMARY KEY ( ProdutoID ) 
);

CREATE TABLE Pedido ( 
    PedidoID   	VARCHAR( 5 ) NOT NULL,
    VendedorID  VARCHAR( 5 ) NOT NULL,
    ClienteID  VARCHAR( 5)  NOT NULL,
    ProdutoID  	VARCHAR( 5 ) NOT NULL,
    Quantidade  INT NOT NULL,
    PRIMARY KEY ( PedidoID ) 
);

INSERT INTO Cliente Values ( '1', 'ACM', 'Rua das Flores, 10', 'Sao Paulo', 'SP', '1222000', 'Brasil', '112233445566');
INSERT INTO Cliente Values ( '2', 'VW', 'Rua do Comercio, 47', 'Sao Paulo', 'SP', '1222010', 'Brasil', '11298735566');
INSERT INTO Cliente Values ( '3', 'GM', 'Via Dutra, 1000', 'Sao Jose dos Campos', 'SP', '1222560', 'Brasil', '122239876566');
INSERT INTO Cliente Values ( '4', 'TEX', 'AV Brasil, 1210', 'Rio de Janeiro', 'RJ', '348890', 'Brasil', '212134567');

INSERT INTO Vendedor Values ( '1', 'Jose Marcio');
INSERT INTO Vendedor Values ( '2', 'Luis Claudio');
INSERT INTO Vendedor Values ( '3', 'Andre Carlos');

INSERT INTO Fornecedor Values ( '1', 'Ferragens Santa Lucia', 'Rua Catalao, 20, Goiania, GO');
INSERT INTO Fornecedor Values ( '2', 'Borracharia Campos', 'Rua dos Ipes 1235, Presidente Prudente, SP');
INSERT INTO Fornecedor Values ( '3', 'Tintas Brasil', 'Avenida dos Guararapes 44, Paulinia, SP');

INSERT INTO Produto Values ( '1', '2', 'Roda', 500.00);
INSERT INTO Produto Values ( '2', '1', 'Mola', 234.00);
INSERT INTO Produto Values ( '3', '1', 'Porca', 11.00);
INSERT INTO Produto Values ( '4', '1', 'Parafuso', 5.30);
INSERT INTO Produto Values ( '5', '2', 'Prego', 1.20);
INSERT INTO Produto Values ( '6', '3', 'Tinta', 234.00);

INSERT INTO Pedido Values ( '1', '2', '4','2', 450);
INSERT INTO Pedido Values ( '2', '1', '2','1', 123);
INSERT INTO Pedido Values ( '3', '2', '1','2', 60);
INSERT INTO Pedido Values ( '4', '3', '2','2', 121);
INSERT INTO Pedido Values ( '5', '3', '3','6', 65);
INSERT INTO Pedido Values ( '6', '1', '3','5', 36);
INSERT INTO Pedido Values ( '7', '2', '1','5', 140);
INSERT INTO Pedido Values ( '8', '3', '4','1', 200);
INSERT INTO Pedido Values ( '9', '3', '2','3', 67);
INSERT INTO Pedido Values ( '10', '1', '2','3', 89);
