#include "Date.h"

#include <iostream>

namespace Chrono
{
	Date::Date(int yy, Month mm, int dd):
    y(yy),
    m(mm),
    d(dd)
	{
        if (!isDate(dd,mm,yy))
            throw Invalid();
    }
            
	Date::Date():
		y(2001),
        m(Date::jan),
		d(1)
	{}
	
	void Date::addYear(int n)
	{
        y += n;
    }
	
	void Date::addMonth(int n)
	{
        if (m==Date::dec)
            m = Date::jan;
        m++;
    }
	
	void Date::addDay(int n)
	{}
    
    // functions

	bool isDate(int d, Chrono::Date::Month m, int y)
	{
		if (d <= 0)
            return false;
        
		int days_in_month = 31;
        
		switch (m)
		{
		case Date::feb: 
         days_in_month = (isLeapYear(y)) ? 29 : 28;
		break;
                
		case Date::abr:
		case Date::jun: 
		case Date::set:
		case Date::nov:
			days_in_month = 30;
		break;
        }
        if (days_in_month<d)
            return false;
	
        return true;
	}
 
	bool isLeapYear(int y)
	{
        return false;
    }
 
	bool operator==(const Date& a, const Date& b)
	{
        return (a.year()==b.year() && a.month()==b.month() && a.day()==b.day());
	}
	
	bool operator!=(const Date& a, const Date& b)
    {
        return !(a==b);
    }

	std::ostream& operator<<(std::ostream& os, const Chrono::Date& d)
	{
        os << d.day() << '/' << d.month() << '/' << d.year();
        return os;
	} 
	
	std::istream& operator>>(std::istream& is, Chrono::Date& dt)
	{
		int y, m, d;
        
		char ch1, ch2, ch3, ch4;
        
		is >> ch1 >> d >> ch2 >> m >> ch3 >> y >>  ch4; // (1,2,2014)
		if (!is) 
			return is;
        
		if (ch1 != '(' || ch2 != ',' || ch3 != ',' || ch4 != ')')
			is.clear();
        
        if (!Chrono::isDate(d,Chrono::Date::Month(m),y))
            throw Date::Invalid();

        dt.setDay(d);
        dt.setMonth(Date::Month(m));
        dt.setYear(y);

        return is;
	}
}