#ifndef _DATE_H_
#define _DATE_H_

#include <iostream>

namespace Chrono
{
 class Date 
 {
 public:
 
    // enumerator
 	enum Month { jan=1, feb, mar, abr, mai, jun, jul, aug, set, outu, nov, dec };
 	
    // to indicate an exception
 	class Invalid {};
 	
    // constructor with parameters
    /*
     This class throws an exception if the parameters do not build a valid date.
    */
 	Date(int y, Month m, int d);
     
    // default constructor
 	Date();
 	
    // accessors methods
    // readers
 	int day() const { return d; }
 	Month month() const { return m; }
 	int year() const { return y; }
     
     // writers
     void setDay(int dd) { d = dd; }
     void setMonth(Month mm) { m = mm; }
     void setYear(int yy) { y = yy; }
 	
    // methods
 	void addDay(int n);
 	void addMonth(int n);
 	void addYear(int n);
 	
 private:
 	int y;
 	Month m;
    int d;
 };  // end class Date

// functions
bool isDate(int y, Date::Month m, int d);
bool isLeapYear(int y);
 
// operator overloading
bool operator==(const Date& a, const Date& b);
bool operator!=(const Date& a, const Date& b); 

std::ostream& operator<<(std::ostream& as, const Date& d);
    
std::istream& operator>>(std::istream& is, Date& dd);

} // end namespace Chrono

#endif
 	