// Templates

template < class T >
class Value
{
	T _value;
	public:
	Value ( T value ) { _value = value; }
          
	T getValue ();
          
	void setValue ( T value );
};
     
template < class T >
T Value<T>::getValue () { return _value; }
     
template < class T >
void Value<T>::setValue ( T value ) { _value = value; }


Value<float> values[10];

// vector: a collection of elements of type T
#include <vector>

// list: A collection of elements of type T. 
//The collection is stored as a bi-directional linked list of elements, each containing a member of type T
#include <list>

// STL streams
#include <strstring>

stringstream strStr;
for ( long i=0; i< 10; i++ )
    strStr << "Element " << i << endl;
   
// Standard Out and Input    
#include <iostream>   
void main ()
{
	char ch;
     
	cin >> ch;
	cout << &#8220;This is the output terminal for STL&#8221; << endl;
}

// Using typedef
typedef vector<int> myVector
typedef map< string, int > myMap

typedef myVector::iterator vectorIterator
typedef myVector::reverse_iterator revVectorIterator    

myVector coll;
for ( myVector::iterator element = coll.begin(); element < coll.end(); element++ )

// algorithms
#include <vector>
#include <algorithm>
#include <iostream>
     
vector<int>              myVec;
vector<int>::iterator    item;

ostream_iterator<int>    out(cout," ");

// generate array
for ( long i=0; i<10; i++ )
    myVec.push_back(i);
    
// shuffle the array
random_shuffle( myVec.begin(), myVec.end() );
copy( myVec.begin(), myVec.end(), out );

// sort the array in ascending order
sort( myVec.begin(), myVec.end() );
copy( myVec.begin(), myVec.end(), out );

/*
Sequence
count, count_if, find, find_if, adjacent_find, for_each, mismatch, equal, search copy, copy_backward, swap, iter_swap, swap_ranges, fill, fill_n, generate, generate_n, replace, replace_if, transform, remove, remove_if, remove_copy, remove_copy_if, unique, unique_copy, reverse, reverse_copy, rotate, rotate_copy, random_shuffle, partition, stable_partition
Sorting
Sort, stable_sort, partial_sort, partial_sort_copy, nth_element, binary_search, lower_bound, upper_bound, equal_range, merge, inplace_merge, includes, set_union, set_intersection, set_difference, set_symmetric_difference, make_heap, push_heap, pop_heap, sort_heap, min, max, min_element, max_element, lexographical_compare, next_permutation, prev_permutation
Numeric
Accumulate, inner_product, partial_sum, adjacent_difference
*/

// BOOST - Ex. Filesystem

#include <iostream>
#include <boost/filesystem.hpp>
using namespace boost::filesystem;

int main(int argc, char* argv[])
{
  if (argc < 2)
  {
    std::cout << "Usage: tut1 path\n";
    return 1;
  }
  std::cout << argv[1] << " " << file_size(argv[1]) << '\n';
  return 0;
}

int main(int argc, char* argv[])
{
  path p (argv[1]);   // p reads clearer than argv[1] in the following code

  if (exists(p))    // does p actually exist?
  {
    if (is_regular_file(p))        // is p a regular file?   
      cout << p << " size is " << file_size(p) << '\n';

    else if (is_directory(p))      // is p a directory?
      cout << p << "is a directory\n";

    else
      cout << p << "exists, but is neither a regular file nor a directory\n";
  }
  else
    cout << p << "does not exist\n";

  return 0;
}

int main(int argc, char* argv[])
{
  path p (argv[1]);   // p reads clearer than argv[1] in the following code

  try
  {
    if (exists(p))    // does p actually exist?
    {
      if (is_regular_file(p))        // is p a regular file?   
        cout << p << " size is " << file_size(p) << '\n';

      else if (is_directory(p))      // is p a directory?
      {
        cout << p << " is a directory containing:\n";

        copy(directory_iterator(p), directory_iterator(), // directory_iterator::value_type
          ostream_iterator<directory_entry>(cout, "\n")); // is directory_entry, which is
                                                          // converted to a path by the
                                                          // path stream inserter
      }

      else
        cout << p << " exists, but is neither a regular file nor a directory\n";
    }
    else
      cout << p << " does not exist\n";
  }

  catch (const filesystem_error& ex)
  {
    cout << ex.what() << '\n';
  }

  return 0;
}