# R aplicado ? Popula??o, Espa?o e Ambiente

# Autores: Sacha Siani e David Fran?a
# Data: 05/07/2017

# Pacotes -----------------------------------------------------------------
require(RCurl)
require(rgdal)
require(dplyr)
require(ggplot2)
require(ggthemes)
require(maptools)

# Inputs ------------------------------------------------------------------

# Configura uma pasta padr?o para o nosso script
setwd("G:/R_curso/")

# endere?os do banco de dados do censo 2010 e da malha censit?ria de 2010
# endereco = "ftp://ftp.ibge.gov.br/Censos/Censo_Demografico_2010/Resultados_do_Universo/Agregados_por_Setores_Censitarios/RR_20150527.zip"
endereco = "ftp://ftp.ibge.gov.br/Censos/Censo_Demografico_2010/Resultados_do_Universo/Agregados_por_Setores_Censitarios/AC_20150527.zip"

# endereco2 = "ftp://geoftp.ibge.gov.br/organizacao_do_territorio/malhas_territoriais/malhas_de_setores_censitarios__divisoes_intramunicipais/censo_2010/setores_censitarios_shp/rr/rr_setores_censitarios.zip"
endereco2 = "ftp://geoftp.ibge.gov.br/organizacao_do_territorio/malhas_territoriais/malhas_de_setores_censitarios__divisoes_intramunicipais/censo_2010/setores_censitarios_shp/ac/ac_setores_censitarios.zip"

# Dentro da nossa pasta padr?o, onde vamos salvar os dados?
# salvar_como = "dado/censo2010_RR"
salvar_como = "dado_censo2010/censo2010_AC"

# Download ----------------------------------------------------------------

# Faz o download das tabelas do universo so censo 2010 de RR e salva no
# definido na vari?vel "salvar_como"
download.file(url = endereco,
              destfile = paste0(salvar_como, ".zip"))

# Para ler os dados temos que descompactar
unzip(zipfile = paste0(salvar_como, ".zip"),
      exdir = salvar_como)

# O mesmo vale para a malha de setores censit?rios
download.file(url = endereco2,
              destfile = paste0(salvar_como, "_malha_setores.zip"))
unzip(zipfile = paste0(salvar_como, "_malha_setores.zip"),
      exdir = paste0(salvar_como, "_malha_setores"))

# Lendo as tabelas --------------------------------------------------------

# Cria lista com as tabelas que baixamos
arquivos = list.files(path = salvar_como,
                      pattern = ".csv$",
                      recursive = T,
                      full.names = T)

# Cria uma lista vazia
censo2010 = list()

# Em cada itera??o (que vai de 1 ao n?mero de tabelas) do "for", fazemos a
# leitura das tabelas e ?s inserimos em nossa lista, at? ent?o vazia
for(n in 1:length(arquivos)){
  censo2010[[n]] = read.csv2(file = arquivos[n],
                              na.strings = "X",
                             stringsAsFactors = F)
}

# Atribui nome ?s tabelas
names(censo2010) = lapply(arquivos,
                          FUN = function(x) {substr(x,
                                                    start = 77,
                                                    stop = nchar(x)-7)}
                          )

# Lendo a malha de setores ------------------------------------------------

# identifica o arquivo '.shp' da malha de setores
arquivo_set = list.files(path = paste0(salvar_como, "_malha_setores"),
                         pattern = ".shp$",
                         recursive = T,
                         full.names = T)

# Faz a leitura do shapefile de setores censit?rios
set_cen2010 = readOGR(dsn = arquivo_set,
                      layer = substr(arquivo_set,
                                     start = 43,
                                     stop = nchar(arquivo_set)-4),
                      stringsAsFactors = F)

# Ser? que deu certo?
plot(set_cen2010)

# Quero ver a tabela de atributos
View(set_cen2010@data)

# Em que proje??o est? o dado?
set_cen2010@proj4string


# Criando um indicador ----------------------------------------------------

# Cria uma nova tabela (data.frame) com os c?digos dos setores
indicador = data.frame(Cod_setor = as.character(censo2010$Basico$Cod_setor))

# Calcula e adiciona o indicador ao "data.frame"
# coleta geral + fossa septica  pelo n domicilios
indicador$esgoto = censo2010$Domicilio02 %>%
  transmute(esgoto = ((V017 + V018) / V016) * 100)

# Join com a tabela de atributos do shapefile dos setores
set_cen2010@data = left_join(set_cen2010@data,
                             indicador,
                             by = c("CD_GEOCODI" = "Cod_setor"))


# Plotando nosso indicador ------------------------------------------------

# Prepara o dado para o ggplot
set_cen2010_f = fortify(set_cen2010, region = "CD_GEOCODI")
set_cen2010_f = left_join(set_cen2010_f, set_cen2010@data, by = c("id" = "CD_GEOCODI"))

# Plota o cartograma usando ggplot
p2 = ggplot() +
  geom_polygon(data = set_cen2010_f, aes(fill = esgoto,
                                         x = long,
                                         y = lat,
                                         group = group)) +
  scale_fill_continuous(name = "(%)") +
  coord_equal() +
 # theme_map() +
  labs(x = NULL,
       y = NULL,
       # title = "Cobertura do esgotamento sanitário em Roraima, 2010",
       title = "Cobertura do esgotamento sanitário no Acre, 2010",
       caption = "Fonte: IBGE (2010)")
p2

