#PACOTES UTILIZADOS NESSE SCRIPT

#instalar os seguintes pacotes:

install.packages("rgdal")
install.packages("MASS")
install.packages("leaps")
install.packages("car")
install.packages("lawstat")
install.packages("lmtest")
install.packages("lsr")

library(rgdal)
library(MASS)
library(leaps)
library(car) 
library(lawstat) 
library(lmtest)
library(lsr) 


#abrinfo um shape com a GDAL

map = readOGR(dsn="C:/Users/VINICIUS/Desktop/Nova pasta", layer = "degrad2004")

#para visualizar o shape

plot(map)

#para visualizar a tabeka de atributo
View(map@data)

#transformando a tabela de atributos num dataframe

dfw = data.frame(map)

#amostragem

prob.selec = dfw$DGRAD_2004 / sum(dfw$DGRAD_2004) 
#runif(1)
#set.seed(1003138)
amostra2004 = dfw[sample(1:nrow(dfw), 100, prob=prob.selec),]  
hist(amostra2004$DGRAD_2004)
hist(dfw$DGRAD_2004)

#SALVAR A AMOSTRA EM UMA TABELA PARA EDIO NO EXCEL

write.csv2(amostra, file="C:/Users/VINICIUS/Dropbox/DISSERTACAO/DADOS/ANALISE_ESTATISTICA/2015/amostra2004.csv")

#=========================================================================================================================================#
#                                                    CRIANDO AS VARIVEIS
#=========================================================================================================================================#
y = (amostra2004$DGRAD_2004)

x1 = (amostra2004$DIST_STRAD)
x2 = (amostra2004$DIST_DSMAT)
x3 = (amostra2004$KERNEL_FOC)

#=========================================================================================================================================#
#                                                    VERIFICANDO A REDALAO  DAS VARIVEIS
#=========================================================================================================================================#

plot(y~x1)
plot(y~x2)
plot(y~x3)


#=====================================================================================================================================#
#                                                           REGRESSO MLTIPLA
#=====================================================================================================================================#
#construo do molelo pelo mtodo stepwise
step(lm(y~x1+x2+x3), direction = "backward")
rm = lm(y ~ x1+x2+x3)
summary(rm)
plot(rm)
coef(rm)
r2_parcial = etaSquared(rm) #calcula quanto cada varivel independente afeta a virvel dependente 
print(r2_parcial)
rela = c((r2_parcial[1,2]),(r2_parcial[2,2]), (r2_parcial[3,2])) #digitar os valores do eta.sq.part com os sinais correspondentes ao tipo da relao da varivel (positiva ou negativa)
barplot(rela, width = 1, xlim=c(0,7), main = "Importncia das Variveis Independentes", ylab = "Importncia relativa",space = FALSE, col = rainbow(5))
legend("bottomright", fill = c(rainbow(5)), legend = c("Distncia de estradas","Distncia de reas desmatadas","Densidade de focos de calor"))
vif(rm) #variance inflation factors
fits=rm$fitted #store the fitted values in variable named "fits"
resids=rm$residuals #store the residual values in a varaible named "resids"
beta1hat=rm$coeff[2] #assign the slope coefficient to the name "beta1hat
confint(rm) #CIs for all parameters
avPlots(rm) #added variable plots
rmt = boxcox(rm)
summary(rmt)
plot(resids~y, pch = 19, col="black", xlab="Valores Observados",  ylab="Resduos")
plot(resids, pch = 19, col="black",xlab="Index",  ylab="Resduos" )

#=====================================================================================================================================#
#                                                         ANLISE DE RESDUOS
#=====================================================================================================================================#

# VERIFICANDO A NORMALIDADE DOS RESDUOS

# MTODO GRFICO

qqnorm(rm$res, col="blue", cex=0.7, xlab="Quantis tericos",  ylab="Quantis amostrais")
qqline(rm$res,col="red", lwd=2)   # coloca linha vermelha no grfico anterior

# TESTE ESTATSTICO (Teste de Shapiro-Wilk para normalidade univariada)
shapiro.test(rm$res)


# VERIFICANDO A HOMOGENEIDADE DAS VARINCIAS

# MTODO GRFICO

boxplot(rm$residuals, xlab="Varivel",  ylab="Valores",  col = "gold", main="Anlise de Varincia")

# TESTE ESTATSTICO (Teste de Breush-Pagan)
bptest(rm)

# VERIFICANDO A INDEPENDNCIA DOS RESDUOS 

# TESTE ESTATSTICO (Teste de Durbin-Watson)

durbinWatsonTest(rm)

dwtest(rm)

