#include "Landscape.h"
#include "TeOVERLAY.h"

Landscape::Landscape()
{
		db_ = new TePostgreSQL();
		if(!db_->connect("localhost", "postgres", "postgres", "tmeio", 0))
			cout << "Erro: " << db_->errorMessage() << endl;
}

Landscape::~Landscape()
{
	db_->close();
}

void Landscape::buildGeometrySets(string layerDeflorestName, string layerCellsName)
{
		TeLayer* layerDeflorest = new TeLayer(layerDeflorestName, db_);
		TeLayer* layerCells = new TeLayer(layerCellsName, db_);

		layerDeflorest->getPolygons(psDeflorest_, "");
		layerCells->getCells(csCells_, "");

		TeRepresentation* repCells = layerCells->getRepresentation(TeCELLS);
		geomTableCellsName_ = repCells ->tableName_;
}

TePolygonSet Landscape::getPsIntersect(TeCell cell)
{
		TePolygon cellPol = TeMakePolygon(cell.box());
		TePolygonSet psCell,psIntersect;
		psCell.clear();
		psCell.add(cellPol);
		psIntersect.clear();
		TeOVERLAY::TeIntersection(psDeflorest_,psCell,psIntersect); 
		return psIntersect;
}

double Landscape::getPolPerimeter(TePolygon p)
{ // Alterar o clculo do permetro caso desconsidere os vazios interiores
		double perimeter = 0;
		for(int l=0; l < p.size(); l++) //calcula o permetro somando o permeto dos vazios
		{	
					perimeter += TeLength(p[l]);
		}
		return perimeter;

}

TeCell Landscape::getCellGeometry(string idCell)
{
		portal_ = db_->getPortal();
		string sql= "SELECT * FROM " + geomTableCellsName_ + " WHERE object_id = '" + idCell + "';";
		portal_->query(sql);
		portal_->fetchGeometry(cell_);
		return cell_;
}


int Landscape::getNumOfCellFrags(TeCell cell)
{
		TePolygonSet intersect = getPsIntersect(cell);
		return intersect.size();
}


double Landscape::getLandscapePerimeter(TeCell cell)
{
		TePolygonSet intersect = getPsIntersect(cell);
		double total = 0;
		if (!intersect.empty())
			for(int i=0; i < intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				total += getPolPerimeter(pol);
			}
		return total;
}

double Landscape::getLandscapeArea(TeCell cell)
{
		return TeGeometryArea(cell.box());
}

double Landscape::getCAMetric(TeCell cell)
{
		TePolygonSet intersect = getPsIntersect(cell);
		double total = 0;
		if (!intersect.empty())
			for(int i=0; i < intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				total += TeGeometryArea(pol);
			}
		return (total/10000); // 1ha = 10000m2
}

double Landscape::getPercentLAND(TeCell cell)
{
	if(getLandscapeArea(cell) != 0)
		return ( getCAMetric(cell) * 10000 / getLandscapeArea(cell) );	
	return 0;
}

double Landscape::getPDMetric(TeCell cell)
{
		if((getLandscapeArea(cell) / 1000000 ) != 0)
			return ( getNumOfCellFrags(cell) / (getLandscapeArea(cell) / 1000000 ) );	
		return 0;
}

double Landscape::getMPSMetric(TeCell cell)
{
	if(getNumOfCellFrags(cell)!= 0)
		return  getCAMetric(cell)  / ( getNumOfCellFrags(cell) );
	return 0;
}

double Landscape::getLSIMetric(TeCell cell)
{
		double P = 0;
		double A = 0;
		P = getLandscapePerimeter(cell);
		A = getLandscapeArea(cell);
		if(A != 0)
			return (P / (4*sqrt(A)));
		return 0;
}

double Landscape::getMSIMetric(TeCell cell)
{
		double R = 0;
		double a = 0;
		double p = 0; 
		double N = getNumOfCellFrags(cell);
		TePolygonSet intersect = getPsIntersect(cell);
		double total = 0;
		if (!intersect.empty())
		{
			for(int i=0; i < intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				p = getPolPerimeter(pol);
				a = TeGeometryArea(pol);
				total += 0.25*(p/a); 
			}
			return (total/N);
		}
		return 0;
}

double Landscape::getAWMSIMetric(TeCell cell)

{
		double a = 0;
		double p = 0; 
		double A = getLandscapeArea(cell);
		double total = 0;
		TePolygonSet intersect = getPsIntersect(cell);
		if (!intersect.empty())
		{
			for(int i=0; i < intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				p = getPolPerimeter(pol);
				a = TeGeometryArea(pol);
				total += (0.25/sqrt(a))*(a/A); 
			}
			return total;
		}
	return 0;
}

double Landscape::getMPFDMetric(TeCell cell)
{
		double a = 0;
		double p = 0;
		double N = getNumOfCellFrags(cell);
		double total = 0;
		TePolygonSet intersect = getPsIntersect(cell);
		if (!intersect.empty())
		{
			for(int i=0; i < intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				p = getPolPerimeter(pol);
				a = TeGeometryArea(pol);
				total += ( log(0.25*p) / log(a) );
			}
			if(N != 0)
				return ((2/N) * total);
		}
		return 0;
}

double Landscape::getAWMPFDMetric(TeCell cell)
{
		double a = 0;
		double p = 0;
		double A = getLandscapeArea(cell);
		double total = 0;
		TePolygonSet intersect = getPsIntersect(cell);
		if (!intersect.empty())
		{
			for(int i=0; i<intersect.size(); i++)
			{
				TePolygon pol = intersect[i];
				p = getPolPerimeter(pol);
				a = TeGeometryArea(pol);
				total += ( (log(0.25*p)/log(a)) * (a/A) );
			}
			return (2 * total);
		}
		return 0;
}






