#ifndef LANSCAPE_H
#define LANDSCAPE_H

#include<string>

#include <TePostgreSQL.h>

using namespace std;

class Landscape
{
public:
	
		// Construtor. Realiza a conexo com o banco.
		Landscape();

		// Destrutor. Fecha a conexo com o banco.
		~Landscape();

		// Cria os conjuntos de polgonos e de clulas doslayers fornecidos
		void buildGeometrySets(string layerDeflorestName, string layerCellsName);

		// Alterar essa funo para otimizar a busca do conjunto de polgonos de interseo
		TePolygonSet getPsIntersect(TeCell cell);

		// Calcula o permetro de um polgono considerando o permeto dos vazios internos
		double getPolPerimeter(TePolygon p);

		// Recupera a geometria da paisagem
		TeCell getCellGeometry(string idCell);
		
		// Calcula a rea da clula. Resultado em m2.
		double getLandscapeArea(TeCell cell);

		// Calcula o no. de polgonos de desflorestamento da clula.
		int getNumOfCellFrags(TeCell cell);

		// Calcula a soma dos permetros dos polgonos de desflorestamento da clula. Resultado em metros
		double getLandscapePerimeter(TeCell cell);

		/* METRICS */
		
		// Metric: Class Area (CA). The sum of areas of all deflorested patches in hectares.
		double getCAMetric(TeCell cell);

		// Metric: Percent Land (%LAND). It equals the percentage of the landscape deflorested (m2).
		double getPercentLAND(TeCell cell);
		
		// Metric: Patch Density (PD). Measures the number of deflorested patches per square kilometer (km2).
		double getPDMetric(TeCell cell);

		// Metric: Mean Patch Size (MPS). Average patch size in hectares.
		double getMPSMetric(TeCell cell);

		// Metric: Landscape Shape Index (LSI). Measures shape complexity of patches
		double getLSIMetric(TeCell cell);

		// Metric: Mean Shape Index (MSI). Is the average Perimeter to area ratio.
		double getMSIMetric(TeCell cell);

		// Metric: Area Weighted Mean Shape Index (AWMSI). Is the perimeter to area ratio, weighted by patch area.
		double getAWMSIMetric(TeCell cell);

		// Metric: Mean Patch Fractal Dimension (MPFD). Measures the average fractal dimension of patches.
		double getMPFDMetric(TeCell cell);

		// Metric: Weighted Mean Patch Fractal Dimension (WMPFD). Equals the average patch Fractal Dimension weighted by patch area.
		double getAWMPFDMetric(TeCell cell);



private:
		TeDatabase* db_; // Conexo com o banco de dados
		TeDatabasePortal* portal_;
		TeCell cell_; // Geometria da clula de paisagem
		string geomTableCellsName_; // Tabela de Geometria da paisagem
		TePolygonSet psDeflorest_;	// Conjunto de polgonos de desflorestamento
		TeCellSet csCells_; // Conjunto de clulas

};

#endif