#include "Landscape.h"

#include <TePostgreSQL.h>
#include <TeCellAlgorithms.h>

int main()
{

	  //** Importar do shape de desmatamento via Terraview para o layer "layer97"

	  // Instancia um objecto conectando com o BD usando o PostgreSQL
		Landscape paisagem;
	  // Cria os conjuntos de polgonos e de clulas dados os nomes dos layers(desmatamento, clulas) 
		paisagem.buildGeometrySets("layer97", "layer97grid");

	  // Teste para a clula "C06L00"
		string idTeste = "C06L00";
		TeCell teste = paisagem.getCellGeometry(idTeste);
		
		cout << "                        Id Cell: " << idTeste << endl;
		cout << "            Number Of Fragments: " <<  paisagem.getNumOfCellFrags(teste) << "" << endl;
		cout << "            Landscape Perimeter: " <<  paisagem.getLandscapePerimeter(teste) << " m" << endl;
		cout << "                 Landscape Area: " <<  paisagem.getLandscapeArea(teste) << " m2" << endl;
		cout << "                     Class Area: " <<  paisagem.getCAMetric(teste)*10000 << " m2" << endl;
		cout << "                   Percent LAND: " <<  paisagem.getPercentLAND(teste)*100 << " %" << endl;
		cout << "                  Patch Density: " <<  paisagem.getPDMetric(teste) << " /Km2" << endl;
		cout << "                Mean Patch Size: " <<  paisagem.getMPSMetric(teste)*10000 << " m2" << endl;
		cout << "          Landscape Shape Index: " <<  paisagem.getLSIMetric(teste)*10000 << " m2" << endl;
		cout << "               Mean Shape Index: " <<  paisagem.getMSIMetric(teste) << " " << endl;
		cout << "              Area Weighted MSI: " <<  paisagem.getAWMSIMetric(teste) << " " << endl;
		cout << "Mean Patch Fractal Dimensional : " <<  paisagem.getMPFDMetric(teste) << endl;
		cout << "           Area Weighted  MPFD : " <<  paisagem.getAWMPFDMetric(teste) << " " << endl;
		

		return 0;
}