calculate_distance_points = function(p1, p2)
    sqrt((p1[1] - p2[1])^2 + (p1[2] - p2[2])^2)

calculate_line_length = function(line)
{
    qtde_points = dim(line[1]@lines[[1]]@Lines[[1]]@coords)[1]
    coords = line[1]@lines[[1]]@Lines[[1]]@coords

    d = 0
    for(k in 1:(qtde_points - 1))
    {
        d = d + calculate_distance_points(coords[k,], coords[k+1,])
    }
    return(d)
}

calculate_line_length_coord = function(line)
{
    qtde_points = dim(line)[1]
    coords = line

    d = 0
    for(k in 1:(qtde_points - 1))
    {
        d = d + calculate_distance_points(coords[k,], coords[k+1,])
    }
    return(d)
}

# distancia entre p0 e o segmento s1->s2
calculate_distance_point_segment = function(p, segA, segB)
{
    p2 = c(segB[1] - segA[1], segB[2] - segA[2]);
    something = p2[1]*p2[1] + p2[2]*p2[2];
    u = ((p[1] - segA[1]) * p2[1] + (p[2] - segA[2]) * p2[2]) / something;

    if (u > 1)
        u = 1
    else if (u < 0)
        u = 0;

    x = segA[1] + u * p2[1];
    y = segA[2] + u * p2[2];

    dx = x - p[1]
    dy = y - p[2]

    dist = sqrt(dx*dx + dy*dy)

    return (dist)
}

calculate_point_from_point_segment = function(p, segA, segB, dist)
{
    dpb = calculate_distance_points(p, segB)
    dpa = calculate_distance_points(p, segA)

    if(dpb > dpa) { dpb = dpa; other = segB; segB=segA; segA = other }

    k = sqrt(dpb^2 - dist^2)
    dab = calculate_distance_points(segA, segB)
    ly = (k * (segA[2] - segB[2]))/dab
    lx = (k * (segA[1] - segB[1]))/dab

    return(c(segB[1] + lx, segB[2] + ly))
}

first_point_of_line = function(lines) 
    lines@lines[[1]]@Lines[[1]]@coords[1,]

last_point_of_line = function(lines)
    lines@lines[[1]]@Lines[[1]]@coords[dim(lines@lines[[1]]@Lines[[1]]@coords)[1],]

add_entry_points = function(spatiallines, points)
{
    lines_ids = getID(spatiallines)

    ptos = vector()
    count_new_lines = 0

    for(i in 1:(dim(points)[1]))
    {
        point = points[i,]@coords

        dd = 1e+15
        pos = 0
        line = 0
        for (j in 1:length(lines_ids))
        {
            qtde_points = dim(spatiallines@lines[[j]]@Lines[[1]]@coords)[1]
            coords = spatiallines@lines[[j]]@Lines[[1]]@coords

            for(k in 1:(qtde_points - 1))
            {
                d = calculate_distance_point_segment(point, coords[k,], coords[k+1,])
                if (d < dd)
                {
                    dd = d
                    kk = k
                    jj = j
                }
            }
        }
        coords = spatiallines@lines[[jj]]@Lines[[1]]@coords

        pto = calculate_point_from_point_segment(point, coords[kk,], coords[kk+1,], dd)

        line1 = rbind(coords[1:kk,], pto)
		if (pto[1] == coords[kk,1] && pto[2] == coords[kk,2])
		{
			print ("EQUAL A: PROBLEM!")
		}
        line2 = rbind(pto, coords[(kk+1):(dim(coords)[1]),])
		if (pto[1] == coords[kk+1,1] && pto[2] == coords[kk+1,2])
		{
			line2 = coords[(kk+1):(dim(coords)[1]),]
		}

        l = Line(line2)
        l = Lines(l, paste(count_new_lines+10000))
        count_new_lines = count_new_lines + 1
        spatiallines@lines[[length(lines_ids)+count_new_lines]] = l
        spatiallines@lines[[jj]]@Lines[[1]]@coords = line1

        ptos = rbind(ptos, c(pto, dd, kk, jj))
    }
    return(spatiallines)
}

######################################################################################################
## calcula os pontos extremos de cada linha, colocando em uma lista com a contagem
## de repeticoes destes pontos

calculate_nodes = function(spatiallines)
{
    point2char = function(point) paste(point[1],"..",point[2],sep="")

    # calcula estes tres elementos
    xx = c()
    yy = c()
    netpoints = vector()

    ids = getID(spatiallines)

    count = 1
    for (i in ids)
    {
        point = first_point_of_line(spatiallines[i])
        name = point2char(point)
        if(is.na(netpoints[name]))
        {
            netpoints[name] = count
            xx[count] = point[1]
            yy[count] = point[2]
            count = count + 1
        }
        point = last_point_of_line(spatiallines[i])
        name = point2char(point)
        if(is.na(netpoints[name]))
        {
            netpoints[name] = count
            xx[count] = point[1]
            yy[count] = point[2]
            count = count + 1
        }
    }

    pts = cbind(xx, yy)
    sp = SpatialPoints(pts)
    nodes = SpatialPointsDataFrame(sp, data=data.frame(ID=paste(1:length(xx))))
    return(list(nodes=nodes, netpoints=netpoints))
}

init_nodes_distance = function(nodes, origins)
{
    nodes@data[,"distance"] = 1e+15
    nodes@data[,"target_id"] = ""

    for(i in 1:(dim(origins)[1]))
    {
        distance = 1e+15
        origin = origins[i,]@coords
        pos = 0

        for(j in 1:(dim(nodes)[1]))
        {
            point = nodes[j,]@coords
            d = calculate_distance_points(origin, point)
            if (d < distance)
            {
                distance = d
                pos = j
            }
        }
        nodes@data[pos,"distance"] = distance
        nodes@data[pos,"target_id"] = as.character(origins@data[i,"ID"])
    }
    return(nodes)
}

create_connectivity_matrix = function(rodovias_completas, netpoints, pondera_rede)
{
    point2char = function(point) paste(point[1],"..",point[2],sep="")
    
    ids = getID(rodovias_completas)

    size = length(netpoints)
    m = matrix(1e+15, nrow = size, ncol = size)
   
    for (i in 1:length(ids))
    {
        point1 = first_point_of_line(rodovias_completas[i])
        name1 = point2char(point1)

        dist = pondera_rede(calculate_line_length(rodovias_completas[i]))
        point2 = last_point_of_line(rodovias_completas[i])
        name2 = point2char(point2)

        # matriz simetrica
        m[netpoints[name1][[1]], netpoints[name2][[1]]] = dist
        m[netpoints[name2][[1]], netpoints[name1][[1]]] = dist
    }
    return(m)
}

update_distances = function(nodes, connect_matrix)
{
	reduce = TRUE
	while(reduce)
	{
		reduce = FALSE
		for(i in 1:(dim(nodes)[1]))
		{
			dist = nodes@data[i,"distance"]
			newdists = connect_matrix[i,] + nodes@data[,"distance"]
			j = which.min(newdists)
			newdist = newdists[j]

			if(dist > newdist)
			{
				nodes@data[i,"distance"] = newdist
				nodes@data[i,"target_id"] = nodes@data[j,"target_id"]
				reduce = TRUE
			}
		}
	}
	return(nodes)
}

getNeighborsOpenNetworkFunction = function(points, network)
{
	spatiallines = network$network
	centroide_lotes = points
	mynodes = network$nodes
	netpoints = network$references
	origin_ids  = getID(centroide_lotes)
    lines_ids = getID(spatiallines)

	return (function(id)
	{
		idpos = which(origin_ids == id)
	    point = centroide_lotes[idpos,]@coords
	    dd = 1e+15
	    pos = 0
	    line = 0
	    for (j in 1:length(lines_ids))
	    {
	        qtde_points = dim(spatiallines@lines[[j]]@Lines[[1]]@coords)[1]
	        coords = spatiallines@lines[[j]]@Lines[[1]]@coords
	        for(k in 1:(qtde_points - 1))
	        {
	            d = calculate_distance_point_segment(point, coords[k,], coords[k+1,])
	            if (d < dd)	
	            {
	                dd = d
					kk = k
	   	            jj = j
	            }
	        }
	    }

	    coords = spatiallines@lines[[jj]]@Lines[[1]]@coords
	
	    pto = calculate_point_from_point_segment(point, coords[kk,], coords[kk+1,], dd)
	
    	line1 = rbind(coords[1:kk,], pto)
	    line2 = rbind(pto, coords[(kk+1):(dim(coords)[1]),])

	    len1 = calculate_line_length_coord(line1)
	    len2 = calculate_line_length_coord(line2)

	    point2char = function(point) paste(point[1],"..",point[2],sep="")

	    ch1 = point2char(coords[1,])
	    dist1 = mynodes@data[netpoints[ch1],"distance"] + len1

	    ch2 = point2char(coords[dim(coords)[1],])
	    dist2 = mynodes@data[netpoints[ch2],"distance"] + len2

	    if (dist1 < dist2)
	    {
		    com1 = mynodes@data[netpoints[ch1],"target_id"]
			return(list(ids=com1, distance=dist1))
	    }    else    {
		    com2 = mynodes@data[netpoints[ch2],"target_id"]
			return(list(ids=com2, distance=dist2))
	    }
	})
}

getNeighborsEuclideanDistanceFunction = function(origin_points, destiny_points)
{
	origin_ids  = getID(origin_points)
	destiny_ids = getID(destiny_points)

	return (function(id)
	{
		pos = which(origin_ids == id)
	    point1 = origin_points[pos,]@coords
	    dd = 1e+15
	    pos = 0
	    for (j in 1:length(destiny_ids))
	    {
		    point2 = destiny_points[j,]@coords
	
			d = calculate_distance_points(point1, point2)
	
            if (d < dd)	
            {
                dd = d
   	            pos = j
	        }
	    }

		neighbor_id = as.character(destiny_points@data[pos,"ID"])
		return (list(ids = neighbor_id, distance = dd))
	})
}

createOpenNetwork = function(destiny_points, network, weight_function)
{
	cat("step 1/5 (adding points)...\n")
	full_network = add_entry_points(network, destiny_points)
	
	cat("step 2/5 (generating network)...\n")
	x = calculate_nodes(full_network)
	network_nodes = x$nodes
	network_references = x$netpoints

	cat("step 3/5 (starting distances)...\n")
	full_mynodes = init_nodes_distance(network_nodes, destiny_points)

	cat("step 4/5 (creating connectivity matrix)...\n")
	connectivity_matrix = create_connectivity_matrix(full_network, network_references, weight_function)

	cat("step 5/5 (updating distances)...\n")
	mynodes_initial = update_distances(full_mynodes, connectivity_matrix)

	return(list(network=full_network, nodes = mynodes_initial, references = network_references))
}

connectToBiggerIntersectionArea = function(spcells, lpolygons)
{
	artcells = as.aRTgeometry(spcells)
	id_cells = getID(spcells)
	table_cells = data.frame(id=id_cells, area=0, father="", stringsAsFactors=FALSE)
	rownames(table_cells) = id_cells

	q = openQuerier(lpolygons)
	for(i in 1:(summary(q)$elements))
	{
		d = getData(q, 1, as.sp=FALSE)
		father = getID(getGeometry(d))
		clip = getClip(artcells, d)
		print(i)
		if(!is.null(clip))
		{
			ids = getID(clip)
			for(j in 1:length(ids))
			{
				idj = ids[j]
				area = clip@polygons[[j]]@area
				if(table_cells[idj,"area"] < area)
				{
					table_cells[idj, "area"] = area
					table_cells[idj, "father"] = father
				}
			}
		}
	}
	return(table_cells)
}



# move to aRT in the next version
getIDlayer = function(layer) 
{
	t = openTable(layer)
	key = summary(t)$keys[1]
	return(getData(t)[,key])
}

GPM = function(layer, get_neighbors)
{
	ids = getIDlayer(layer)

	result = list()

	s = aRTsilent()
	aRTsilent(TRUE)
	cont = 1
	for(i in ids)
	{
		print(i)
		rel = get_neighbors(i)
		result[[i]] = rel
		cont = cont + 1
	}
	aRTsilent(s)
	return (result)
}

saveGAL = function(gpm, filename, layer1, layer2)
{
	ids = names(gpm)
	qtde = length(ids)

	zz <- file(filename, "w")

	cat(c(layer1, layer2), sep="\n", file=zz) # layers
	cat(qtde, sep="\n", file=zz)              # size

	for (i in ids)
	{
		cat(i, sep="\n", file=zz)                    # ID
		cat(length(gpm[[i]]$ids), sep="\n", file=zz) # size
		cat(gpm[[i]]$ids, sep="\n", file=zz)         # neighbors
	}
	close(zz)
}

