source("gpm.R")

require(aRT);aRTsilent(FALSE)
con=openConn(u="root", pas="art")
db=openDb(con, "talita")

db

namellotes         = "lotes_UTM_Buffer10m"
namelcells         = "cells_350_parcial"
namelcomunidades   = "comunidades_gleba_UTM"
namelrodovias      = "Rodovias_Gleba_new_UTM"
namelgleba         = "limite_gleba_UTM"
namellotesoriginal = "lotes_UTM"
namelcentroides    = "centroid_cells_350"

lrodovias      = openLayer(db, namelrodovias)
llotes         = openLayer(db, namellotes)
lgleba         = openLayer(db, namelgleba)
lcomunidades   = openLayer(db, namelcomunidades)
lcells         = openLayer(db, namelcells)
llotesoriginal = openLayer(db, namellotesoriginal)
lcentroides    = openLayer(db, namelcentroides)

rodovias    = getLines(lrodovias)
gleba       = getPolygons(lgleba)
comunidades = getPoints(lcomunidades)
pts         = getPoints(lcentroides)

centroide_lotes = getOperation(llotesoriginal, operation="centroid")
centroide_cells = getOperation(lcells, operation="centroid")

###########################################################
## LER CELULAS DO BANCO
# para conjuntos pequenos
cells       = getCells(lcells)

## MOVER ISTO PARA A PROXIMA VERSAO DO ART COMO PARAMETRO NO GETX DO LAYER
# para conjuntos grandes
#qcells = openQuerier(lcells)
#d = getData(qcells, 6000)
#d2 = getData(qcells, 6000)
#d3 = getData(qcells)
#cells = d3
#cells@polygons = c(d3@polygons, d2@polygons, d@polygons)
#cells@plotOrder = 1:(length(getID(cells)))
###########################################################

# MUITO LENTO
table_cells = connectToBiggerIntersectionArea(cells, llotesoriginal)

get_property_from_cell = function(id)
	list(ids=table_cells[id,"father"], area = table_cells[id,"area"])

get_neighbors_function = function(layer, operation)
	function(id)
		list(ids = getRelation(layer, operation, layer, id))


network = createOpenNetwork(comunidades, rodovias, function(dist) dist/3)

get_neighbors_cells     = get_neighbors_function(lcells, "intersect")
get_neighbors_lotes     = get_neighbors_function(llotes, "intersect")
get_neighbors_euclidean = getNeighborsEuclideanDistanceFunction(centroide_lotes, comunidades)
get_neighbors_network   = getNeighborsOpenNetworkFunction(centroide_lotes, network)

# ALGUNS SAO LENTOS, OUTROS SAO RAPIDOS
gpmcells     = GPM(lcells, get_neighbors_cells)
gpmlotes     = GPM(llotes, get_neighbors_lotes)
gpmdistance  = GPM(llotes, get_neighbors_euclidean)
gpmnetwork   = GPM(llotes, get_neighbors_network)
gpmcellsprop = GPM(lcells, get_property_from_cell)

saveGAL(gpmcells,    "cell-neighborhood.gal",           namelcells, namelcells)
saveGAL(gpmlotes,    "lotes-neighborhood.gal",          namellotes, namellotes)
saveGAL(gpmdistance, "lotes-comunidades-euclidean.gal", namellotes, namelcomunidades)
saveGAL(gpmnetwork,  "lotes-comunidades-gpm.gal",       namellotes, namelcomunidades)
saveGAL(gpmcellsprop,"celulas-propriedades.gal",        namelcells, namellotes)

plot_neighborhood_lines = function(points, neighborhood)
{
	id_points = getID(points)

	for(i in 1:length(id_points))
	{
		p1 = points@coords[i,]

		neighbors = neighborhood[[i]]$ids

		for(j in 1:length(neighbors))
		{
			mywhich = which(neighbors[j] == id_points)
			if(length(mywhich) > 0)
			{
				p2 = points@coords[mywhich,]
				lines(c(p1[1],p2[1]), c(p1[2],p2[2]), lty=2)
			}
		}
	}
}

plot_by_querier = function(layer, colors)
{
	q = openQuerier(layer)
	for(i in 1:(summary(q)$elements))
	{
		d = getData(q, 1)
		plot(d, col=colors[i], add=T)
	}
}

plot_lotes = function()
{
	q = openQuerier(llotesoriginal)
	total = summary(q)$elements

	d = getData(q, 239)
	plot(d, add=T)

	for(i in 1:20)
	{
		d = getData(q, 150)
		plot(d, add=T)
	}
}

## BUG DO ART: CORRIGIR NA PROXIMA VERSAO
for(i in 1:length(getID(cells)))
	cells@polygons[[i]]@Polygons[[1]]@hole = FALSE

###################################################################
## PROPRIEDADES-CELULAS
fat= as.numeric(table_cells[,"father"])
colors_lotes = sample(rainbow(3239))
real_colors = colors_lotes[fat]
real_colors[which(is.na(real_colors))]= "white"

pdf("celulas-propriedades.pdf", 10, 10)
plot(cells, col=real_colors)
plot_lotes()
dev.off()
###################################################################


###################################################################
## VIZINHANCA DE CELULAS
pdf("vizinhanca-celulas.pdf", 10, 10)
colors_cells = rainbow(length(getID(centroide_cells)))

plot(cells, col=colors_cells)
plot(gleba, add=T)
plot_lotes()
plot_neighborhood_lines(centroide_cells, gpmcells)
plot(centroide_cells, pch=".", cex=3, add=T)
plot(centroide_cells, pch=".", cex=2, add=T, col=colors_cells)
dev.off()

###################################################################
## VIZINHANCA DE LOTES
pdf("vizinhanca-lotes.pdf", 30, 30)
len = length(getID(centroide_lotes))
colors_lotes=sample(rainbow(len), len)
plot(gleba)
plot_by_querier(llotesoriginal, colors_lotes)

plot_neighborhood_lines(centroide_lotes, gpmlotes)
plot(centroide_lotes, pch=".", cex=3, add=T)
plot(centroide_lotes, pch=".", cex=2, add=T, col=colors_lotes)
dev.off()
###################################################################

plot_neighborhood_points = function(start_points, end_points, end_points_colors, neighborhood, lines, border)
{
	id_end_points       = getID(end_points)
	length_end_points   = length(id_end_points)
	length_start_points = length(getID(start_points))

	plot(border)

	for(i in 1:length_start_points)
	{
		mywhich = which(neighborhood[[i]]$ids == id_end_points)
		if(length(mywhich) > 0)
		{
			col = end_points_colors[mywhich]
			plot(start_points[i,], col=col, pch=20, add=T)
		}
	}

	plot(lines, add=T)

	for(i in 1:length_end_points)
	{
		col = end_points_colors[i]
		id = getID(end_points)[i]
		plot(end_points[i,], bg=col, pch=21, cex=3,add=T)
		text(end_points@coords[i,1], end_points@coords[i,2], labels=i)
	}
}

###################################################################
## VIZINHANCA DE LOTES/COMUNIDADES
pdf("gpm-lotes-comunidades.pdf", 10, 10)

l = length(getID(comunidades))
colors_comunidades = rainbow(l)
colors_comunidades = colors_comunidades[c(9,2,3,10,5,6,16,23,20,4,1,12,13,14,15,21,17,18,19,11,7,22,8)]
colors_comunidades

par(mfrow=c(1,2))
plot_neighborhood_points(centroide_lotes, comunidades, colors_comunidades, gpmnetwork, rodovias, gleba)
plot_neighborhood_points(centroide_lotes, comunidades, colors_comunidades, gpmdistance, rodovias, gleba)

dev.off()
###################################################################
