######################################################################
# Data mining using Rough Sets
# A presentation made on 2015-11-11 by Alber Sánchez 
# alber.ipia at inpe.br 
# Sample script 
# --------------------------------------------------------------------
# An Internet connection is required to install the packages
######################################################################



# Sample data 
Diploma <- c("MCE", "MCE", "MBA", "MCE", "MCE", "Msc", "Msc", "Msc")
Experience <- c("Low", "Low", "Low", "Medium", "Medium", "Medium", "High", "High")
French <- c("No", "No", "No", "No", "No", "No", "Yes", "Yes")
Reference <- c("Good", "Neutral", "Neutral", "Good", "Excellent", "Excellent", "Excellent", "Excellent")
Decision <- c("Stand by", "Stand by", "Reject", "Reject", "Accept", "Accept", "Accept", "Accept")



######################################################################
# Knowledge reduction using the package RoughSetKnowledgeReduction
######################################################################
install.packages("RoughSetKnowledgeReduction")
library(RoughSetKnowledgeReduction)

# encode the string attributes as numbers
Diploma1 <- Diploma
Diploma1 <- replace(Diploma1, which(Diploma1 == "MBA"), 0)
Diploma1 <- replace(Diploma1, which(Diploma1 == "MCE"), 1)
Diploma1 <- replace(Diploma1, which(Diploma1 == "Msc"), 2)
Experience1 <- Experience
Experience1 <- replace(Experience1, which(Experience1 == "Low"), 0)
Experience1 <- replace(Experience1, which(Experience1 == "Medium"), 1)
Experience1 <- replace(Experience1, which(Experience1 == "High"), 2)
French1 <- French
French1 <- replace(French1, which(French1 == "No"), 0)
French1 <- replace(French1, which(French1 == "Yes"), 2)
Reference1 <- Reference
Reference1 <- replace(Reference1, which(Reference1 == "Neutral"), 0)
Reference1 <- replace(Reference1, which(Reference1 == "Good"), 1)
Reference1 <- replace(Reference1, which(Reference1 == "Excellent"), 2)
Decision1 <- Decision
Decision1 <- replace(Decision1, which(Decision1 == "Reject"), 0)
Decision1 <- replace(Decision1, which(Decision1 == "Stand by"), 1)
Decision1 <- replace(Decision1, which(Decision1 == "Accept"), 2)
mat1 <- as.matrix(data.frame(Diploma1, Experience1, French1, Reference1, Decision1))

# create a decision table
dt1 <- decisionTable(mat1)
print(dt1)

# compute a condition reduct
firstCR <- findFirstConditionReduct(dt1)
print(firstCR)

# compute a value reduct
vr <- computeValueReduct(firstCR)
print(vr)

# compute some rule metrics
computeSupportConsistency(vr,dt1)

# classify new examples, in this case, classify again the original decision table
classDT <- classifyDecisionTable(vr, dt1)
print(classDT)

# unload the package 
detach("package:RoughSetKnowledgeReduction", unload=TRUE)




######################################################################
# Knowledge reduction using the package RoughSets
######################################################################
install.packages("RoughSets")
library("RoughSets")

df <- data.frame(Diploma, Experience, French, Reference, Decision)
print(df)

# create a decision table
dt <- SF.asDecisionTable(dataset = df, decision.attr = 5)


#  compute the discernibility matrix
dm <- BC.discernibility.mat.RST(dt, range.object = NULL)


# compute the reducts
allReducts <- FS.all.reducts.computation(dm)
print(allReducts)
firstReduct  <- allReducts$decision.reduct$reduct1
print(firstReduct)


# generate rules
fs <- SF.asFeatureSubset(colNames = firstReduct, decisionTable = dt)
print(fs)
rules <- RI.indiscernibilityBasedRules.RST(dt, fs)
print(rules)
