#include <HidroPluginStarter.h>
#include <HidroMainWindow.h>
#include <HidroEditionWindow.h>
#include <HidroAttributeWindow.h>
#include <HidroClassWindow.h>
#include <HidroBatchPointsWindow.h>
#include <HidroTopographicIndexWindow.h>
#include <HidroCellHigWindow.h>
#include <HidroMorphometricVariablesWindow.h>
#include <HidroHydrologicalVariablesWindow.h>
#include <HidroTreeClassifyWindow.h>
#include <HidroFlowDependentVariablesWindow.h>
#include <HidroDrainageExtractionWindow.h>
#include <HidroCrossSectionBottomLevelWindow.h>
#include <HidroFlowPathWindow.h>
#include <HidroConsistentDEMWindow.h>
#include <HidroBlocksWindow.h>
#include <HidroDEMFillWindow.h>
#include <HidroRiversLWindow.h>

#include <HidroBoostAlgorithmFactory.h>

#include <PluginParameters.h>
#include <TViewAbstractPlugin.h>

#include <qaction.h>
#include <qtoolbar.h>
#include <qmainwindow.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstring.h>

//#include <vld.h>

void
HidroPluginStarter::init()
{
  start();
}

void
HidroPluginStarter::end()
{
  //delete main window objects
	if(_mainWindow)
	{
		delete _mainWindow;
		_mainWindow = 0;
	}

	if(_mainAction)
	{
		delete _mainAction;
		_mainAction = 0;
	}

//delete edition window objects
	if(_editionWindow)
	{
		delete _editionWindow;
		_editionWindow = 0;
	}

	if(_editionAction)
	{
		delete _editionAction;
		_editionAction = 0;
	}

//delete attr window objects
	if(_attrWindow)
	{
		delete _attrWindow;
		_attrWindow = 0;
	}

	if(_attrAction)
	{
		delete _attrAction;
		_attrAction = 0;
	}

//delete class window objects
	if(_classWindow)
	{
		delete _classWindow;
		_classWindow = 0;
	}

	if(_classAction)
	{
		delete _classAction;
		_classAction = 0;
	}

//delete batch points window objects
	if(_batchPointsWindow)
	{
		delete _batchPointsWindow;
		_batchPointsWindow = 0;
	}

  if(_batchPointsAction)
	{
		delete _batchPointsAction;
		_batchPointsAction = 0;
	}

  //delete Topographic Index window objects  
	if(_topographicIndexWindow)
	{
		delete _topographicIndexWindow;
		_topographicIndexWindow = 0;
	}

  if(_topographicIndexAction)
	{
		delete _topographicIndexAction;
		_topographicIndexAction = 0;
	}


  //delete Cell.Hig Index window objects  
	if(_cellHigWindow)
	{
		delete _cellHigWindow;
		_cellHigWindow = 0;
	}

  if(_cellHigAction)
	{
		delete _cellHigAction;
		_cellHigAction = 0;
	}
  
  //delete Morphometric Variable window objects
	if(_morphometricVariablesWindow)
	{
		delete _morphometricVariablesWindow;
		_morphometricVariablesWindow = 0;
	}

  if(_morphometricVariablesAction)
	{
		delete _morphometricVariablesAction;
		_morphometricVariablesAction = 0;
	}


  //delete Hydrological Variable window objects
	if(_hydrologicalVariablesWindow)
	{
		delete _hydrologicalVariablesWindow;
		_hydrologicalVariablesWindow = 0;
	}

  if(_hydrologicalVariablesAction)
	{
		delete _hydrologicalVariablesAction;
		_hydrologicalVariablesAction = 0;
	}


  //delete Tree Classify window objects
	if(_treeClassifyWindow)
	{
		delete _treeClassifyWindow;
		_treeClassifyWindow = 0;
	}

  if(_treeClassifyAction)
	{
		delete _treeClassifyAction;
		_treeClassifyAction = 0;
	}


  //delete Flow Dependent Variable objects
	if(_flowDependentVariablesWindow)
	{
		delete _flowDependentVariablesWindow;
		_flowDependentVariablesWindow = 0;
	}

  if(_flowDependentVariablesAction)
	{
		delete _flowDependentVariablesAction;
		_flowDependentVariablesAction = 0;
	}

  //delete Drainage Extraction objects
	if(_drainageExtractionWindow)
	{
		delete _drainageExtractionWindow;
		_drainageExtractionWindow = 0;
	}

  if(_drainageExtractioAction)
	{
		delete _drainageExtractioAction;
		_drainageExtractioAction = 0;
	}

  //delete Cross Section Bottom Level objects
	if(_crossSectionBottomLevelWindow)
	{
		delete _crossSectionBottomLevelWindow;
		_crossSectionBottomLevelWindow = 0;
	}

  if(_crossSectionBottomLevelAction)
	{
		delete _crossSectionBottomLevelAction;
		_crossSectionBottomLevelAction = 0;
	}

  //delete Flow Path objects
	if(_flowPathWindow)
	{
		delete _flowPathWindow;
		_flowPathWindow = 0;
	}

  if(_flowPathAction)
	{
		delete _flowPathAction;
		_flowPathAction = 0;
	}

  //delete Consistent DEM objects
	if(_consistentDEMWindow)
	{
		delete _consistentDEMWindow;
		_consistentDEMWindow = 0;
	}

  if(_consistentDEMAction)
	{
		delete _consistentDEMAction;
		_consistentDEMAction = 0;
	}

  if(_terrahidroMenu)
	{
		delete _terrahidroMenu;
		_terrahidroMenu = 0;
	}

  //delete blocks objects
  if(_blocksWindow)
  {
	  delete _blocksWindow;
	  _blocksWindow = 0;
  }

  if(_blocksAction)
  {
	  delete _blocksAction;
	  _blocksAction = 0;
  }

  //delete DEM Fill objects
  if(_demFillWindow)
  {
	  delete _demFillWindow;
	  _demFillWindow = 0;
  }

  if(_demFillAction)
  {
	  delete _demFillAction;
	  _demFillAction = 0;
  }

  //delete Rivers Lenghtobjects
	if(_riversLWindow)
	{
		delete _riversLWindow;
		_riversLWindow = 0;
	}

  if(_riversLAction)
	{
		delete _riversLAction;
		_riversLAction = 0;
	}
	
	_started = false;
}

HidroPluginStarter::HidroPluginStarter(PluginParameters* params):_params(params),TViewAbstractPlugin(params)
{
	_mainWindow		= NULL;
	_mainAction		= NULL;

	_editionWindow	= NULL;
	_editionAction  = NULL;

	_attrWindow		= NULL;
	_attrAction		= NULL;

	_classWindow	= NULL;
	_classAction	= NULL;

  _batchPointsWindow = NULL;
  _batchPointsAction = NULL;

  _cellHigWindow = NULL;
  _cellHigAction = NULL;

  _topographicIndexWindow = NULL;
  _topographicIndexAction = NULL;

  _morphometricVariablesWindow = NULL;
  _morphometricVariablesAction = NULL;

  _hydrologicalVariablesWindow = NULL;
  _hydrologicalVariablesAction = NULL;

  _treeClassifyWindow = NULL;
  _treeClassifyAction = NULL;

  _flowDependentVariablesWindow = NULL;
  _flowDependentVariablesAction = NULL;

  _drainageExtractionWindow = NULL;
  _drainageExtractioAction = NULL;

  _crossSectionBottomLevelWindow = NULL;
  _crossSectionBottomLevelAction = NULL;

  _flowPathWindow = NULL;
  _flowPathAction = NULL;

  _consistentDEMWindow = NULL;
  _consistentDEMAction = NULL;

  _blocksWindow = NULL;
  _blocksAction = NULL;

  _demFillWindow = NULL;
  _demFillAction = NULL;

  _riversLWindow = NULL;
  _riversLAction = NULL;

  _terrahidroMenu = NULL;

	_started = false;
}

HidroPluginStarter::~HidroPluginStarter()
{
  end();
}

bool HidroPluginStarter::start()
{
	if(_started)
	{
		return true;
	}

	if(!_params)
	{
		return false;
	}

//Inserting the tool buttons into TerraView toolbar
	QPtrList< QToolBar > tvToolBarsList = _params->qtmain_widget_ptr_->toolBars( Qt::DockTop );

	if( tvToolBarsList.count() > 0 ) 
	{
//create main action
		_mainAction = new QAction(NULL, tr("Hydrological Tools"));
		_mainAction->setText(tr("Hydrological Tools"));
		_mainAction->setMenuText(tr("Hydrological Tools"));
		_mainAction->setToolTip(tr("Hydrological Tools"));
		_mainAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconMain.bmp")));
		_mainAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _mainAction, SIGNAL( activated() ), this, SLOT( showMainWindow() ) );

//create edition action
		_editionAction = new QAction(NULL, tr("Graph Edition"));
		_editionAction->setText(tr("Graph Edition"));
		_editionAction->setMenuText(tr("Graph Edition"));
		_editionAction->setToolTip(tr("Graph Edition"));
		_editionAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconEdition.bmp")));
		_editionAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _editionAction, SIGNAL( activated() ), this, SLOT( showEditionWindow() ) );

//create attribute action
		/*_attrAction = new QAction(NULL, tr("Graph Attributes"));
		_attrAction->setText(tr("Graph Attributes"));
		_attrAction->setMenuText(tr("Graph Attributes"));
		_attrAction->setToolTip(tr("Graph Attributes"));
		_attrAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconAttribute.bmp")));
		_attrAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _attrAction, SIGNAL( activated() ), this, SLOT( showAttributeWindow() ) );*/

//create attribute action
		/*_classAction = new QAction(NULL, tr("Graph Classes"));
		_classAction->setText(tr("Graph Classes"));
		_classAction->setMenuText(tr("Graph Classes"));
		_classAction->setToolTip(tr("Graph Classes"));
		_classAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconClass.bmp")));
		_classAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _classAction, SIGNAL( activated() ), this, SLOT( showClassWindow() ) );*/

	}
 
//create batch points action
		_batchPointsAction = new QAction(NULL, tr("Create Batch Points"));
		_batchPointsAction->setText(tr("Create Batch Points"));
		_batchPointsAction->setMenuText(tr("Create Batch Points"));
		_batchPointsAction->setToolTip(tr("Create Batch Points"));
		_batchPointsAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		_batchPointsAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _batchPointsAction, SIGNAL( activated() ), this, SLOT( showBatchPointsWindow() ) );

//create TopographicIndexWindow action
		_topographicIndexAction = new QAction(NULL, tr("Topographic Index"));
		_topographicIndexAction->setText(tr("Topographic Index"));
		_topographicIndexAction->setMenuText(tr("Topographic &Index"));
		_topographicIndexAction->setToolTip(tr("Topographic Index"));
		//_topographicIndexAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_topographicIndexAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _topographicIndexAction, SIGNAL( activated() ), this, SLOT( showTopographicIndexWindow() ) );

//create HidroCellHigWindow action
		_cellHigAction = new QAction(NULL, tr("Cell Generator"));
		_cellHigAction->setText(tr("Cell Generator"));
		_cellHigAction->setMenuText(tr("Cell &Generator"));
		_cellHigAction->setToolTip(tr("Cell Generator"));
		//_hidroCellHigAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_hidroCellHigAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _cellHigAction, SIGNAL( activated() ), this, SLOT( showCellHigWindow() ) );

//create morphometric variables action
		_morphometricVariablesAction = new QAction(NULL, tr("Morphometric Variables"));
		_morphometricVariablesAction->setText(tr("Morphometric Variables"));
		_morphometricVariablesAction->setMenuText(tr("Morphometric Variables"));
		_morphometricVariablesAction->setToolTip(tr("Morphometric Variables"));
		//_morphometricVariablesAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_morphometricVariablesAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _morphometricVariablesAction, SIGNAL( activated() ), this, SLOT( showMorphometricVariablesWindow() ) );


//create hydrological variables action
		_hydrologicalVariablesAction = new QAction(NULL, tr("Hydrological Variables"));
		_hydrologicalVariablesAction->setText(tr("Hydrological Variables"));
		_hydrologicalVariablesAction->setMenuText(tr("Hydrological Variables"));
		_hydrologicalVariablesAction->setToolTip(tr("Hydrological Variables"));
		connect( _hydrologicalVariablesAction, SIGNAL( activated() ), this, SLOT( showHydrologicalVariablesWindow() ) );


//create tree classify action
		_treeClassifyAction = new QAction(NULL, tr("Tree Classify"));
		_treeClassifyAction->setText(tr("Tree Classify"));
		_treeClassifyAction->setMenuText(tr("Tree Classify"));
		_treeClassifyAction->setToolTip(tr("Tree Classify"));
		connect( _treeClassifyAction, SIGNAL( activated() ), this, SLOT( showTreeClassifyWindow() ) );


    //create Flow Dependent Variables action
		_flowDependentVariablesAction = new QAction(NULL, tr("Flow Dependent Variables"));
		_flowDependentVariablesAction->setText(tr("Flow Dependent Variables"));
		_flowDependentVariablesAction->setMenuText(tr("Flow Dependent Variables"));
		_flowDependentVariablesAction->setToolTip(tr("Flow Dependent Variables"));
		//_flowDependentVariablesAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_flowDependentVariablesAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _flowDependentVariablesAction, SIGNAL( activated() ), this, SLOT( showHidroFlowDependentVariablesWindow() ) );


    //create Drainage Extraction action
		_drainageExtractioAction = new QAction(NULL, tr("Drainage Extraction"));
		_drainageExtractioAction->setText(tr("Drainage Extraction"));
		_drainageExtractioAction->setMenuText(tr("Drainage Extraction"));
		_drainageExtractioAction->setToolTip(tr("Drainage Extraction"));
		//_flowDependentVariablesAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_flowDependentVariablesAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _drainageExtractioAction, SIGNAL( activated() ), this, SLOT( showHidroDrainageExtractionWindow() ) );


    //create Cross Section Bottom Level action
		_crossSectionBottomLevelAction = new QAction(NULL, tr("Cross Section Bottom Level"));
		_crossSectionBottomLevelAction->setText(tr("Cross Section Bottom Level"));
		_crossSectionBottomLevelAction->setMenuText(tr("Cross Section Bottom Level"));
		_crossSectionBottomLevelAction->setToolTip(tr("Cross Section Bottom Level"));
		//_crossSectionBottomLevelAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_crossSectionBottomLevelAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
		connect( _crossSectionBottomLevelAction, SIGNAL( activated() ), this, SLOT( showHidroCrossSectionBottomLevelWindow() ) );

    //create Flow Path action
		_flowPathAction = new QAction(NULL, tr("Flow Path"));
		_flowPathAction->setText(tr("Flow Path"));
		_flowPathAction->setMenuText(tr("Flow Path"));
		_flowPathAction->setToolTip(tr("Flow Path"));
		//_flowPathAction->setIconSet( QIconSet( QPixmap::fromMimeSource("hidroIconBatchPoint.bmp")));
		//_flowPathAction->addTo(_params->qtmain_widget_ptr_->toolBars(Qt::DockTop).at(0));
    connect( _flowPathAction, SIGNAL( activated() ), this, SLOT( showHidroFlowPathWindow() ) );

     //create Flow Path action
		_consistentDEMAction = new QAction(NULL, tr("Consistent DEM"));
		_consistentDEMAction->setText(tr("Consistent DEM"));
		_consistentDEMAction->setMenuText(tr("Consistent DEM"));
		_consistentDEMAction->setToolTip(tr("Consistent DEM"));		
    connect( _consistentDEMAction, SIGNAL( activated() ), this, SLOT( showHidroConsistentDEMWindow() ) );

    //create Blocks action
    _blocksAction = new QAction(NULL, tr("Blocks"));
    _blocksAction->setText(tr("Blocks"));
    _blocksAction->setMenuText(tr("Blocks"));
    _blocksAction->setToolTip(tr("Blocks"));
    connect( _blocksAction, SIGNAL( activated() ), this, SLOT( showHidroBlocksWindow() ) );

    //create Blocks action
    _demFillAction = new QAction(NULL, tr("DEM Fill"));
    _demFillAction->setText(tr("DEM Fill"));
    _demFillAction->setMenuText(tr("DEM Fill"));
    _demFillAction->setToolTip(tr("DEM Fill"));
    connect( _demFillAction, SIGNAL( activated() ), this, SLOT( showHidroDEMFillWindow() ) );

    //create Rivers Lenght action
		_riversLAction = new QAction(NULL, tr("Rivers Lenght"));
		_riversLAction->setText(tr("Rivers Lenght"));
		_riversLAction->setMenuText(tr("Rivers Lenght"));
		_riversLAction->setToolTip(tr("Rivers Lenght"));		
    connect( _riversLAction, SIGNAL( activated() ), this, SLOT( showHidroRiversLWindow() ) );
    
	_started = true;
  
  // Insert itens to TerraView menu
  createTerraHidroMenu();

  if( _terrahidroMenu )
  {
    _batchPointsAction->addTo( _terrahidroMenu );

    // DEM Preprocessing menu
    QPopupMenu* demPreprocessingMenu = getHidroSubMenu( "Terra&Hidro.&DEM Preprocessing" );    
    _demFillAction->addTo( demPreprocessingMenu );

    // MHD INPE menu
     QPopupMenu* mgbMenu = getHidroSubMenu( "Terra&Hidro.&MHD INPE" );    
    _cellHigAction->addTo( mgbMenu );
    _topographicIndexAction->addTo( mgbMenu );
    _crossSectionBottomLevelAction->addTo( mgbMenu );
    _consistentDEMAction->addTo( mgbMenu );
    _blocksAction->addTo( mgbMenu );

    // Attribute Extraction Menu
    QPopupMenu* attributeExtractionMenu = getHidroSubMenu( "Terra&Hidro.&Attribute Extraction" );
    _morphometricVariablesAction->addTo( attributeExtractionMenu );
    _hydrologicalVariablesAction->addTo( attributeExtractionMenu );
    _treeClassifyAction->addTo( attributeExtractionMenu );
    _flowDependentVariablesAction->addTo( attributeExtractionMenu );
    _drainageExtractioAction->addTo( attributeExtractionMenu );
    _flowPathAction->addTo( attributeExtractionMenu );
    _riversLAction->addTo( attributeExtractionMenu );
  }  
  
	return true;
}

QPopupMenu*
HidroPluginStarter::getHidroSubMenu( const std::string& plgMenu )
{
	std::vector<std::string> plgTexts;
//	QMainWindow* mainWin = getMainWindow();
    QPopupMenu* insertion_menu = _terrahidroMenu;

	if(!plgMenu.empty())
	{
		TeSplitString(plgMenu, ".", plgTexts);
		TEAGN_TRUE_OR_THROW( ( plgTexts.size() > 0 ), QObject::tr("Invalid plugin meny entries number") );
		  
		unsigned int pme_index = 1;

		while( pme_index < plgTexts.size() ) {
		  QPopupMenu* target_sub_menu = 0;
		    
		  for( unsigned int insertion_menu_index = 0 ; 
			insertion_menu_index < insertion_menu->count() ;
			++insertion_menu_index ) {
		    
			int menuid = insertion_menu->idAt( insertion_menu_index );
		    
			if( insertion_menu->text( menuid ) == 
				plgTexts[ pme_index ].c_str() ) {
				target_sub_menu = insertion_menu->findItem(menuid)->popup();

				TEAGN_TRUE_OR_THROW( ( target_sub_menu != 0 ), "Popup menu map error" )
		      
			  break; 
			}
		  }
		  
		  if( target_sub_menu == 0 ) {
			int new_insertion_menu_index = insertion_menu->count();
		    
			target_sub_menu = new QPopupMenu( insertion_menu,
			  plgTexts[ pme_index ].c_str() ); 
		   
			insertion_menu->insertItem( plgTexts[ 
			  pme_index ].c_str(), target_sub_menu, -1, 
				new_insertion_menu_index );
		        
//			int new_insertion_menu_id = insertion_menu->idAt( new_insertion_menu_index );
		  }         

		  insertion_menu = target_sub_menu;
		  
		  ++pme_index;
		};        
	}

	return insertion_menu;
}

void
HidroPluginStarter::createTerraHidroMenu()
{
  // create TerraHidro Menu
  QMainWindow* mainWin = getMainWindow();
  QMenuBar* mainMenu = mainWin->menuBar();  
  int terrahidro_menu_id = -1;
  std::string terraHidroMenuString = "Terra&Hidro";

  // found terra hidro Menu
  bool found = false;
  int idx = -1;
  for(unsigned int i = 0; i < mainMenu->count() ; i++)
  {
    idx = mainMenu->idAt(i);    
    if(mainMenu->text(idx).isEmpty())
      continue;
    if(mainMenu->text(idx) == terraHidroMenuString.c_str())
    {
      found = true;
      break;
    }
  }  

  if( found )
  {
    _terrahidroMenu = mainMenu->findItem(idx)->popup();
  }
  else
  {
    int terrahidro_menu_index = mainMenu->count()-1;
  		    
	  _terrahidroMenu = new QPopupMenu( mainMenu, terraHidroMenuString.c_str() );    
  		
    mainMenu->insertItem( terraHidroMenuString.c_str(), _terrahidroMenu, -1, 
		  terrahidro_menu_index );
  		    
	  terrahidro_menu_id = mainMenu->idAt( terrahidro_menu_index );
  }
}

void HidroPluginStarter::showMainWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}

	if(_mainWindow)
	{
		delete _mainWindow;
	}

	_mainWindow = new HidroMainWindow(_params->qtmain_widget_ptr_, "Main Window", false);

	_mainWindow->init(_params);

	_mainWindow->show();
}

void HidroPluginStarter::showEditionWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}

	if(_editionWindow)
	{
		delete _editionWindow;
	}

	_editionWindow = new HidroEditionWindow(_params->qtmain_widget_ptr_, "Edition Window", false);

	_editionWindow->init(_params);

	_editionWindow->show();
}

void HidroPluginStarter::showAttributeWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_attrWindow)
	{
		delete _attrWindow;
	}

	_attrWindow = new HidroAttributeWindow(_params->qtmain_widget_ptr_, "Attribute Window", false);

	_attrWindow->init(_params);

	_attrWindow->show();
}

void HidroPluginStarter::showClassWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_classWindow)
	{
		delete _classWindow;
	}

	_classWindow = new HidroClassWindow(_params->qtmain_widget_ptr_, "Class Window", false);

	_classWindow->init(_params);

	_classWindow->show();
}

void HidroPluginStarter::showBatchPointsWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_batchPointsWindow)
	{
		delete _batchPointsWindow;
	}

	_batchPointsWindow = new HidroBatchPointsWindow(_params->qtmain_widget_ptr_, "Batch Points Window", false);

	_batchPointsWindow->init2(_params, false);

	_batchPointsWindow->show();
}

void HidroPluginStarter::showTopographicIndexWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}	

	if(_topographicIndexWindow)
	{
		delete _topographicIndexWindow;
	}

	_topographicIndexWindow = new HidroTopographicIndexWindow(_params->qtmain_widget_ptr_, "Topographic Index Window", false);

	_topographicIndexWindow->init(_params);

	_topographicIndexWindow->show();
}

void HidroPluginStarter::showCellHigWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}	

	if(_cellHigWindow)
	{
		delete _cellHigWindow;
	}

	_cellHigWindow = new HidroCellHigWindow(_params->qtmain_widget_ptr_, "Topographic Index Window", false);

	_cellHigWindow->init(_params);

	_cellHigWindow->show();
}

void HidroPluginStarter::showMorphometricVariablesWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_morphometricVariablesWindow)
	{
		delete _morphometricVariablesWindow;
	}

	_morphometricVariablesWindow = new HidroMorphometricVariablesWindow(_params->qtmain_widget_ptr_, "Morphometric Variables", false);

	_morphometricVariablesWindow->init(_params );

	_morphometricVariablesWindow->show();
}


void HidroPluginStarter::showHydrologicalVariablesWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_hydrologicalVariablesWindow)
	{
		delete _hydrologicalVariablesWindow;
	}

	_hydrologicalVariablesWindow = new HidroHydrologicalVariablesWindow(_params->qtmain_widget_ptr_, "Hydrological Variables", false);

	_hydrologicalVariablesWindow->init(_params );

	_hydrologicalVariablesWindow->show();
}

void HidroPluginStarter::showTreeClassifyWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_treeClassifyWindow)
	{
		delete _treeClassifyWindow;
	}

	_treeClassifyWindow = new HidroTreeClassifyWindow(_params->qtmain_widget_ptr_, "Tree Classify", false);

	_treeClassifyWindow->init(_params );

	_treeClassifyWindow->show();
}

void HidroPluginStarter::showHidroFlowDependentVariablesWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_flowDependentVariablesWindow)
	{
		delete _flowDependentVariablesWindow;
	}

	_flowDependentVariablesWindow = new HidroFlowDependentVariablesWindow(_params->qtmain_widget_ptr_, "Morphometric Variables", false);

	_flowDependentVariablesWindow->init(_params );

	_flowDependentVariablesWindow->show();
}


void HidroPluginStarter::showHidroDrainageExtractionWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_drainageExtractionWindow)
	{
		delete _drainageExtractionWindow;
	}

	_drainageExtractionWindow = new HidroDrainageExtractionWindow(_params->qtmain_widget_ptr_, "Morphometric Variables", false);

	_drainageExtractionWindow->init(_params );

	_drainageExtractionWindow->show();
}

void HidroPluginStarter::showHidroCrossSectionBottomLevelWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_crossSectionBottomLevelWindow)
	{
		delete _crossSectionBottomLevelWindow;
	}

	_crossSectionBottomLevelWindow = new HidroCrossSectionBottomLevelWindow(_params->qtmain_widget_ptr_, "Cross Section Bottom Level", false);

	_crossSectionBottomLevelWindow->init(_params );

	_crossSectionBottomLevelWindow->show();
}

void HidroPluginStarter::showHidroFlowPathWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_flowPathWindow)
	{
		delete _flowPathWindow;
	}

	_flowPathWindow = new HidroFlowPathWindow(_params->qtmain_widget_ptr_, "Flow Path", false);

	_flowPathWindow->init(_params );

	_flowPathWindow->show();
}

void HidroPluginStarter::showHidroConsistentDEMWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_consistentDEMWindow)
	{
		delete _consistentDEMWindow;
	}

	_consistentDEMWindow = new HidroConsistentDEMWindow(_params->qtmain_widget_ptr_, "Consistent DEM", false);

	_consistentDEMWindow->init(_params );

	_consistentDEMWindow->show();
}

void HidroPluginStarter::showHidroBlocksWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_blocksWindow)
	{
		delete _blocksWindow;
	}

	_blocksWindow = new HidroBlocksWindow(_params->qtmain_widget_ptr_, "Flow Path", false);

	_blocksWindow->init(_params );

	_blocksWindow->show();
}

void HidroPluginStarter::showHidroDEMFillWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_demFillWindow)
	{
		delete _demFillWindow;
	}

	_demFillWindow = new HidroDEMFillWindow(_params->qtmain_widget_ptr_, "DEM FILL", false);

	_demFillWindow->init(_params );

	_demFillWindow->show();
}


void HidroPluginStarter::showHidroRiversLWindow()
{
	if(!_params->getCurrentDatabasePtr())
	{
		QMessageBox::warning(_params->qtmain_widget_ptr_, tr("Warning"), tr("Database not connected."));
		return;
	}
	
	if(_riversLWindow)
	{
		delete _riversLWindow;
	}

	_riversLWindow = new HidroRiversLWindow(_params->qtmain_widget_ptr_, "Flow Path", false);

	_riversLWindow->init(_params );

	_riversLWindow->show();
}
