/******************************************************************************
* Hidro development team
* 
* Terra View Hidro Plugin
* 
* @(#) HidroPluginStarter.h
*
*******************************************************************************
*
* $Rev: 7969 $:
*
* $Author: eric $:
*
* $Date: 2009-08-06 09:58:50 -0300 (qui, 06 ago 2009) $:
*
******************************************************************************/

/*!
	\brief This is the Hidro Config Group.
	@defgroup hidroConfig The Group for Plugin Configuration.
*/

#ifndef HIDRO_PLUGIN_STARTER_H_
#define HIDRO_PLUGIN_STARTER_H_

/** 
  * \file HidroPluginStarter.h
  *
  * \class HidroPluginStarter
  *
  * \brief This file is a class to define the plugin starter
  *
  * This class is usefull to start terra hidro plugin, when plugin
  * was started on terraView application, a toolbar was insert in tv app
  * creating two new buttons. First button was used to open a hidro
  * modeling interface and a second button was used to open a hidro
  * edition interface.
  *
  * This class is a qt class dependency, (moc operation) because has
  * to receive qt events send by application.
  *
  * \author Eric Silva Abreu <eric.abreu@funcate.org.br>
  * \version 1.0
  *
  * \sa HidroPluginCode.h
/*!
  @ingroup hidroConfig
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/
#include <qobject.h>
#include <qpopupmenu.h>

class QAction;

class PluginParameters;

class HidroMainWindow;
class HidroEditionWindow;
class HidroAttributeWindow;
class HidroClassWindow;
class HidroBatchPointsWindow;
class HidroTopographicIndexWindow;
class HidroCellHigWindow;
class HidroMorphometricVariablesWindow;
class HidroHydrologicalVariablesWindow;
class HidroTreeClassifyWindow;
class HidroFlowDependentVariablesWindow;
class HidroDrainageExtractionWindow;
class HidroCrossSectionBottomLevelWindow;
class HidroFlowPathWindow;
class HidroConsistentDEMWindow;
class HidroBlocksWindow;
class HidroDEMFillWindow;
class HidroRiversLWindow;

#include <TViewAbstractPlugin.h>


class HidroPluginStarter : public QObject, public TViewAbstractPlugin
{
	Q_OBJECT

public:

	/** @name Constructor and Destructor Methods
		* Methods related to instantiation and destruction.
		*/
	//@{		
	
	/** \brief Default Constructor.
	*/
	HidroPluginStarter(PluginParameters* params);
	
	/** \brief Virtual destructor.
	*/
	~HidroPluginStarter();

	//@}

public:

	/** @name Behavioral Methods
		* Methods related to hidro start plugin behavior.
		*/
	//@{

    /** \brief Function used to start hidro plugin in terraView app.
      *
      * \return Return true if the plugin was started correctly and false in other case.
	  *         Its necessary has a current database to start this plugin.
      */
	bool start();

  /**	\brief Initializer method.
	 */
	void init();

	/**	\brief Finalizer method.
	 */
	void end();

  /** \brief Create TerraHidro menu in the TerraView main menu bar.
    */
	void createTerraHidroMenu();

  QPopupMenu* getHidroSubMenu(const std::string& plgMenu = "");

	//@}

public slots:

	/** @name Slots Methods
		* Methods related to qt events.
		*/
	//@{

	/** \brief Function used when modeling button was pressed in tv app, a hidro modeling interface was openned
      */
	void showMainWindow();

	/** \brief Function used when edition button was pressed in tv app, a hidro edition interface was openned
      */
	void showEditionWindow();

	/** \brief Function used when attribute button was pressed in tv app, a hidro attributeinterface was openned
      */
	void showAttributeWindow();

	/** \brief Function used when class button was pressed in tv app, a hidro class interface was openned
      */
	void showClassWindow();
  
  /** \brief Function used when class button was pressed in tv app, a hidro class batch points creation was openned
    */
	void showBatchPointsWindow();  

  /** \brief Function used when class button was pressed in tv app, a hidro class batch points creation was openned
    */
	void showTopographicIndexWindow();  
  
  /** \brief Function used when class button was pressed in tv app, a hidro class batch points creation was openned
    */
	void showCellHigWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Morphometric Variables creation was openned
    */
	void showMorphometricVariablesWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Hydrological Variables creation was openned
    */
	void showHydrologicalVariablesWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Tree Classify creation was openned
    */
	void showTreeClassifyWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Flow Dependent Variables creation was openned
    */
	void showHidroFlowDependentVariablesWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Drainage Extraction creation was openned
    */
	void showHidroDrainageExtractionWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Cross Section Bottom Level was openned
    */
	void showHidroCrossSectionBottomLevelWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Flow Path was openned
    */
	void showHidroFlowPathWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Consistent DEM was openned
    */
	void showHidroConsistentDEMWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Blocks was openned
    */
	void showHidroBlocksWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class DEM Fill was openned
    */
	void showHidroDEMFillWindow();

  /** \brief Function used when class button was pressed in tv app, a hidro class Blocks was openned
    */
	void showHidroRiversLWindow ();
  

  //@}

protected:
  QPopupMenu* _terrahidroMenu;  //!< TerraHidro Menu

	PluginParameters*		_params;			//!< Attribute used to define the parameters from application

	HidroMainWindow*		_mainWindow;		//!< Attribute used to define the hidro modeling interface

	HidroEditionWindow*		_editionWindow;		//!< Attribute used to define the hidro edition interface

	HidroAttributeWindow*	_attrWindow;		//!< Attribute used to define the hidro attribute interface

	HidroClassWindow*		_classWindow;		//!< Attribute used to define the hidro class interface
 
  HidroBatchPointsWindow*  _batchPointsWindow; //!< Attribute used to define the hidro class batch points creation

  HidroTopographicIndexWindow*  _topographicIndexWindow; //!< Attribute used to define the hidro class topographic index
  
  HidroCellHigWindow*  _cellHigWindow; //!< Attribute used to define the hidro class topographic index

  HidroMorphometricVariablesWindow*  _morphometricVariablesWindow; //!< Attribute used to define the hidro class topographic index

  HidroHydrologicalVariablesWindow*  _hydrologicalVariablesWindow; //!< Attribute used to define the hidro class topographic index

  HidroTreeClassifyWindow*  _treeClassifyWindow; //!< Attribute used to define the hidro class topographic index

  HidroFlowDependentVariablesWindow*  _flowDependentVariablesWindow; //!< Attribute used to define the hidro class topographic index

  HidroDrainageExtractionWindow* _drainageExtractionWindow; //!< Attribute used to define the hidro class topographic index

  HidroCrossSectionBottomLevelWindow* _crossSectionBottomLevelWindow; //!< Attribute used to define the Cross Section Bottom Level inteface

  HidroFlowPathWindow* _flowPathWindow; //!< Attribute used to define the Flow Path inteface

  HidroConsistentDEMWindow* _consistentDEMWindow; //!< Attribute used to define the Consistent DEM inteface

  HidroBlocksWindow* _blocksWindow; //!< Attribute used to define the Blocks inteface

  HidroDEMFillWindow* _demFillWindow; //!< Attribute used to define the DEM fill inteface

  HidroRiversLWindow* _riversLWindow; //!< Attribute used to define the Rivers Lenght inteface

  

	bool					_started;			//!< Attribute used to define if hidro plugin is already started

	QAction*				_mainAction;		//!< Attribute used to define the qt action to start modeling interface

	QAction*				_editionAction;		//!< Attribute used to define the qt action to start edition interface

	QAction*				_attrAction;		//!< Attribute used to define the qt action to start attribute interface

	QAction*				_classAction;		//!< Attribute used to define the qt action to start class interface
  
  QAction*				_batchPointsAction;		//!< Attribute used to define the qt action to start class batch points creation

  QAction*				_topographicIndexAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_cellHigAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_morphometricVariablesAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_hydrologicalVariablesAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_treeClassifyAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_flowDependentVariablesAction;		//!< Attribute used to define the qt action to start class topographic index
  
  QAction*				_drainageExtractioAction;		//!< Attribute used to define the qt action to start class topographic index

  QAction*				_crossSectionBottomLevelAction;		//!< Attribute used to define the qt action to start class Cross Section Bottom Level
  
  QAction*				_flowPathAction;		//!< Attribute used to define the qt action to start class Flow Path
  
  QAction*				_consistentDEMAction;		//!< Attribute used to define the qt action to start class Consistent DEM

  QAction*				_blocksAction;		//!< Attribute used to define the qt action to start class Blocks

  QAction*				_demFillAction;		//!< Attribute used to define the qt action to start class DEM fill

  QAction*				_riversLAction;		//!< Attribute used to define the qt action to start class Rivers Lenght
};

/*
** ---------------------------------------------------------------
** End:
*/

#endif //HIDRO_PLUGIN_STARTER_H_