
/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_ACCUMULATOR_H
#define HIDRO_ACCUMULATOR_H

/** 
  * \file HidroAccumulator.h
  *
  *
  * \brief This file is a class to accumulate the LDD. 
  *
  * \author Alexandre Copertino Jardim <alexcj@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroAccumulator : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddRaster LDD raster.
    * \param accumulatedRaster Accumulated raster (result).
    * \param kmArea If true calculate the accumulated area in km.
	  **/
    HidroAccumulator( TeRaster* lddRaster, TeRaster* &accumulatedRaster, bool kmArea = false );

    ~HidroAccumulator();
  
  //@}

  /**
   * @name Behavioral Methods
	 * Methods related to hidro accumulator behavior.
	**/
	//@{

    /**
    * \brief Accumulate the LDD.	
    * \return True if successful false otherwise.
	  **/
    bool execute();
  //@}

protected:
  bool cancel();

  bool initAccumulatedMatrixPixel();

  bool initAccumulatedMatrixArea();
   

  /**
   * @name Attributes
	 * Attributes related to hidro accumulator.
	**/
	//@{
  TeRaster* lddRaster_;
  TeRaster* &accumulatedRaster_;
  
  TePDIMatrix<float> accumulatedMatrix_;

  bool kmArea_;
  //@}
};

#endif //HIDRO_ACCUMULATOR_H

