/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_DRAINAGE_H
#define HIDRO_DRAINAGE_H

/** 
  * \file HidroDrainage.h
  *
  *
  * \brief This file is a class extract the drainage of a accumulated matrix.
  *
  * \author Alexandre Copertino Jardim <alexcj@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroDrainage : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param accumulatedMatrix Accumulated matrix (input).
    * \param drainageMatrix Drainage matrix (result).
	  **/
    HidroDrainage(
      TeRaster* accumulatedRaster,
      TeRaster* &drainageRaster,
      float threshold );

    ~HidroDrainage();
  
  //@}

  /**
   * @name Behavioral Methods
	 * Methods related to hidro Drainage behavior.
	**/
	//@{

    /**
    * \brief Extract the drainage of a accumulated.
    * \param threshold The threshold of what is a drainage or not.
    * \return True if successful false otherwise.
	  **/
    bool execute();

  //@}

protected:
  bool cancel();

  /**
   * @name Attributes
	 * Attributes related to hidro Drainage.
	**/
	//@{    
    TeRaster* accumulatedRaster_;    
    TeRaster* &drainageRaster_;

    TePDIMatrix<float> accumulatedMatrix_; //!< accumulated matrix.    
    TePDIMatrix<unsigned char> drainageMatrix_; //!< drainage matrix.

    float threshold_;
  //@}
};

#endif //HIDRO_DRAINAGE_H

