#include <HidroGenerateQueueStatistics.h>

#include <HidroFlowUtils.h>

void HidroGenerateQueueStatistics::start( std::string queueStatisticsFileName, unsigned int initialQueueSize )
{
  queueStatisticsStream_.reset();

  queueStatisticsFile_.setName( queueStatisticsFileName.c_str() );
  if( queueStatisticsFile_.open( IO_ReadWrite  ) )
  {
    queueStatisticsStream_.setDevice( &queueStatisticsFile_ );

    queueStatisticsStream_ << "Start Time: " << Time::instance().actualTimeString().c_str();
    queueStatisticsStream_ << "Queue size: " << Te2String( initialQueueSize ).c_str() << "\n\n";  
    queueStatisticsFile_.flush();
  }
}

void HidroGenerateQueueStatistics::increment( unsigned int newQueueSize )
{
  if( queueStatisticsFile_.isOpen() )
  {
    queueStatisticsStream_ << "Actual Time: " << Time::instance().actualTimeString().c_str();
    queueStatisticsStream_ << "Queue size: " << Te2String( newQueueSize ).c_str() << "\n";
    queueStatisticsStream_ << "Processing time: " << Time::instance().partialString().c_str() << "\n\n";
    queueStatisticsFile_.flush();
  }
}

void HidroGenerateQueueStatistics::finsh( unsigned int newQueueSize )
{
  if( queueStatisticsFile_.isOpen() )
  {
    queueStatisticsStream_ << "End Time: " << Time::instance().actualTimeString().c_str();
    queueStatisticsStream_ << "Queue size: " << Te2String( newQueueSize ).c_str() << "\n";
    queueStatisticsStream_ << "Total Processing time: " << Time::instance().partialString().c_str();
    queueStatisticsFile_.close();
  }
}

void HidroGenerateQueueStatistics::informHoleProblem( unsigned int holeProblemNumber, unsigned int newQueueSize )
{
  if( queueStatisticsFile_.isOpen() )
  {
    queueStatisticsStream_ << "Actual Time: " << Time::instance().actualTimeString().c_str();
    queueStatisticsStream_ << "hole Problem : " << Te2String( holeProblemNumber ).c_str() << "\n";
    queueStatisticsStream_ << "Queue size: " << Te2String( newQueueSize ).c_str() << "\n";
    queueStatisticsStream_ << "Processing time: " << Time::instance().partialString().c_str() << "\n\n";
    queueStatisticsFile_.flush();
  }
}