#ifndef HIDRO_lengthSLOPE_RASTER_H
#define HIDRO_lengthSLOPE_RASTER_H

#include <HidroFlowAlgorithm.h>
#include <HidroUpscaleRaster.h>

#include <TePDIMatrix.hpp>

#include<queue>

class TeRaster;

class HidroLengthSlope : public HidroFlowAlgorithm
{
public:
  HidroLengthSlope(
    TeRaster* lddRaster,
    TeRaster* demRaster,
    TeRaster* accumulatedRaster,
    TeRaster* outletPixelsRaster,
    TeRaster* &lengthRaster,
    TeRaster* &slopeRaster,
    TeRaster* &visitedPixelsRaster,
    int factor,    
    bool useMinimumSlope,
    double minimumSlope,
    double headSlope );

  bool execute();

protected: 
  OutletPixel reFindOutletPixel( unsigned int line, unsigned int column );

  priority_queue< OutletPixel, deque<OutletPixel>, greater<OutletPixel> > outletPixelsQueue_;

  double calculateUpstream( unsigned int line,
    unsigned int column,
    const OutletPixel &outletPixel,
    unsigned int &upLine,
    unsigned int &upColumn );

  double calculateDownstream( unsigned int line,
    unsigned int column,
    const OutletPixel &outletPixel,
    unsigned int &downLine,
    unsigned int &downColumn );

  double distanceKm( const unsigned int &lineFrom,
      const unsigned int &columnFrom,
      const unsigned int &lineTo,
      const unsigned int &columnTo );

  double A_;
  double F_;
  double E2_;
  double resx_;
  double resy_;

  bool useMinimumSlope_;
  double minimumSlope_;
  double headSlope_;

  unsigned char neighborDirection_[3][3];

  bool upStream( const unsigned int &lineFrom,
      const unsigned int &columnFrom,
      unsigned int &lineTo,
      unsigned int &columnTo );

  bool cancel();

  TeRaster* lddRaster_;
  TeRaster* demRaster_;
  TeRaster* accumulatedRaster_;
  TeRaster* outletPixelsRaster_;
  TeRaster* &lengthRaster_;
  TeRaster* &slopeRaster_;
  TeRaster* &visitedPixelsRaster_;

  int factor_;

  TePDIMatrix<float> accumulatedMatrix_;
  //TePDIMatrix<float> lendthMatrix_;
  //TePDIMatrix<float> slopeMatrix_;
  TePDIMatrix<unsigned char> outletPixelsMatrix_;  
};


#endif // HIDRO_lengthSLOPE_RASTER_H