/*!
	\brief This is the Hidro MGB Group.
	@defgroup hidroMGB The Group for Plugin MGB Classes.
*/

#ifndef HIDRO_BLOCKS_H
#define HIDRO_BLOCKS_H

/** 
  * \file HidroBlocks.h
  *
  *
  * \brief This file is a class to define the blocks.
  *
  * \author Alexandre Copertino Jardim <alexandre@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroMGB
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>
#include <stdio.h>
#include <string.h>

class TeRaster;

class HidroBlocks  : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param demRaster DEM raster (input).    
    * \param soilsRaster Solos raster (input).
    * \param vegetationRaster Vegetation raster (input).
	  **/
  HidroBlocks( TeRaster* demRaster,
    TeRaster* soilsRaster,
    TeRaster* vegetationRaster,
    std::string cellFileName,
    TeRaster* &blocksGridRaster,
    std::string blocksFileName,
    std::string groupsFileName
    );
  
  //@}

  ~HidroBlocks();

  bool execute();

protected:
  bool cancel();
  

  TeRaster* demRaster_;
  TeRaster* soilsRaster_;
  TeRaster* vegetationRaster_;     
  TeRaster* &blocksGridRaster_;

  // nome do arquivo do Modelo CELL.HIG
  std::string cellFileName_;
  
  // nome do arquivo de sada BLOCOS.HIG
  std::string blocksFileName_;

  // nome do arquivo de sada GRUPOS.HIG
  std::string groupsFileName_;

  // ponteiro para arquivo de saida
  FILE *blocksFile_;

  // ponteiro para arquivo de saida
  FILE *groupsFile_;

  // ponteiro para arquivo de clulas
  FILE *cellFile_;

};

class Block
{
public:
  Block( int soils, int vegetation );

  bool operator==( const Block &rightSide ) const; 

  int soils_;
  int vegetation_;
};

class BlocksGroups
{
public:
  BlocksGroups() {};

  int insert( int soils, int vegetation );

  std::vector<Block> blocksVector_;
};


#endif HIDRO_BLOCKS_H