#ifndef _HIDRO_TREE_CLASSIFY_H_
#define _HIDRO_TREE_CLASSIFY_H_

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;
class HidroTreeClassify : public HidroFlowAlgorithm

{
public:
  HidroTreeClassify( TeRaster* *Raster, TeRaster* lddRaster, TeRaster* &drainRaster, unsigned int* options );

  ~HidroTreeClassify();

  bool execute();

protected:

  bool cancel();
  bool findSprings();

  TeRaster* *Raster_;
  TeRaster* lddRaster_;
  TeRaster* &drainRaster_;
  unsigned int *options_;

//  TePDIMatrix<unsigned char> lddMatrix_;
  TePDIMatrix<unsigned int> drainMatrix_;
  TePDIMatrix<float> varMatrix_;

};

#endif //_HIDRO_TREE_CLASSIFY_H_