/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroCellHig.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qstring.h>
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>

#include <string>

void HidroCellHigWindow::okPushButton_clicked()
{
  // Check inputs
  // DEM
  if(demComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}

  // Blocks
  //if(blocksComboBox->currentText().isEmpty())
	//{
	//	QMessageBox::warning(this, tr("Warning"), tr("Input Blocks layer not defined."));
	//	return;
	//}
  
  // highSubwatershed
  //if(highSubwatershedComboBox->currentText().isEmpty())
	//{
	//	QMessageBox::warning(this, tr("Warning"), tr("Input high Subwatershed layer not defined."));
	//	return;
	//}

  // UpLDD
  if(lowLDDComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Low LDD layer not defined."));
		return;
	}

  // lowAccumulated
  if(lowAccumulatedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input low Accumulated layer not defined."));
		return;
	}

  // lowSubwatershed
  if(lowSubwatershedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input low Subwatershed layer not defined."));
		return;
	}

  // lowSubwatershed
  if(lowSubwatershedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input low Subwatershed layer not defined."));
		return;
	}

  // Length
  if(lengthComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Length layer not defined."));
		return;
	}

  // Slope
  if(slopeComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Slope layer not defined."));
		return;
	}

  //pathsComboBox
  if(pathsComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Paths layer not defined."));
		return;
	}

  // Output File
  if(outputFileLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output File not defined."));
		return;
  }

  // open input raster's
  HidroUtils utils(parameters_->getCurrentDatabasePtr());  
  
  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // Blocks
  TeLayer* blocksLayer = NULL;
	//blocksLayer = utils.getLayerByName( blocksComboBox->currentText().latin1() );
  TeRaster* blocksRaster = NULL;
  //blocksRaster = blocksLayer->raster();

  // high Subwatershed
  //TeLayer* highSubwatershedLayer = NULL;
	//highSubwatershedLayer = utils.getLayerByName( highSubwatershedComboBox->currentText().latin1() );
  TeRaster* highSubwatershedRaster = NULL;
  //highSubwatershedRaster = highSubwatershedLayer->raster();

  // UpLDD
  TeLayer* lowLDDLayer = NULL;
	lowLDDLayer = utils.getLayerByName( lowLDDComboBox->currentText().latin1() );
  TeRaster* lowLDDRaster = NULL;
  lowLDDRaster = lowLDDLayer->raster();

  // low Accumulated
  TeLayer* lowAccumulatedLayer = NULL;
	lowAccumulatedLayer = utils.getLayerByName( lowAccumulatedComboBox->currentText().latin1() );
  TeRaster* lowAccumulatedRaster = NULL;
  lowAccumulatedRaster = lowAccumulatedLayer->raster();

  // low Subwatershed
  TeLayer* lowSubwatershedLayer = NULL;
	lowSubwatershedLayer = utils.getLayerByName( lowSubwatershedComboBox->currentText().latin1() );
  TeRaster* lowSubwatershedRaster = NULL;
  lowSubwatershedRaster = lowSubwatershedLayer->raster();  

  // Length
  TeLayer* lengthLayer = NULL;
	lengthLayer = utils.getLayerByName( lengthComboBox->currentText().latin1() );
  TeRaster* lengthRaster = NULL;
  lengthRaster = lengthLayer->raster();  

  // Slope
  TeLayer* slopeLayer = NULL;
	slopeLayer = utils.getLayerByName( slopeComboBox->currentText().latin1() );
  TeRaster* slopeRaster = NULL;
  slopeRaster = slopeLayer->raster();

  // Paths
  TeLayer* pathsLayer = NULL;
	pathsLayer = utils.getLayerByName( pathsComboBox->currentText().latin1() );
  TeRaster* pathsRaster = NULL;
  pathsRaster = pathsLayer->raster();

  // Parameters
  std::string outFileName = outputFileLineEdit->text().latin1();

 //Cell Hig
  HidroCellHig cellHig( demRaster,
    blocksRaster,
    highSubwatershedRaster,
    lowLDDRaster,
    lowAccumulatedRaster,
    lowSubwatershedRaster,
    lengthRaster,
    slopeRaster,
    pathsRaster,
    outFileName );

  // execut the algorithm
  if( !cellHig.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(cellHig.getErrorMessage().c_str()));
    
    if( demRaster )
    {
      delete demRaster;
    }

    if( blocksRaster )
    {
      delete blocksRaster;
    }

    if( highSubwatershedRaster )
    {
      delete highSubwatershedRaster;
    }

    if( lowLDDRaster )
    {
      delete lowLDDRaster;
    }

    if( lowAccumulatedRaster )
    {
      delete lowAccumulatedRaster;
    }

    if( lowSubwatershedRaster )
    {
      delete lowSubwatershedRaster;
    }

    if( lengthRaster )
    {
      delete lengthRaster;
    }

    if( slopeRaster )
    {
      delete slopeRaster;
    }

    if( pathsRaster )
    {
      delete pathsRaster;
    }
    
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastDEM", demComboBox->currentText() );
  //settings.writeEntry( "lastBlocks", blocksComboBox->currentText() );
  //settings.writeEntry( "lastSUB", highSubwatershedComboBox->currentText() );
  settings.writeEntry( "lastUpLDD", lowLDDComboBox->currentText() );
  settings.writeEntry( "lastUpSUB", lowSubwatershedComboBox->currentText() );
  settings.writeEntry( "lastUpACU", lowAccumulatedComboBox->currentText() );  
  settings.writeEntry( "lastSlope", slopeComboBox->currentText() );
  settings.writeEntry( "lastLength", lengthComboBox->currentText() );
  settings.writeEntry( "lastPaths", pathsComboBox->currentText() );
  settings.writeEntry( "lastCELLHIG", outputFileLineEdit->text() );

  // lsdate the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Cell HIG\n");
  message.append("Start Time: ");
  message.append( cellHig.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( cellHig.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( cellHig.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );

  // close the window
  accept();

}

bool HidroCellHigWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  demComboBox->clear();
	demComboBox->insertItem("");

  //blocksComboBox->clear();
	//blocksComboBox->insertItem("");

	//highSubwatershedComboBox->clear();
	//highSubwatershedComboBox->insertItem("");

  lowLDDComboBox->clear();
	lowLDDComboBox->insertItem("");

  lowAccumulatedComboBox->clear();
	lowAccumulatedComboBox->insertItem("");

  lowSubwatershedComboBox->clear();
	lowSubwatershedComboBox->insertItem("");

  lengthComboBox->clear();
	lengthComboBox->insertItem("");

  slopeComboBox->clear();
	slopeComboBox->insertItem("");

  pathsComboBox->clear();
	pathsComboBox->insertItem("");  

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		demComboBox->insertItem(layerNames[i].c_str());
		//blocksComboBox->insertItem(layerNames[i].c_str());
    //highSubwatershedComboBox->insertItem(layerNames[i].c_str());
    lowLDDComboBox->insertItem(layerNames[i].c_str());
    lowAccumulatedComboBox->insertItem(layerNames[i].c_str());
    lowSubwatershedComboBox->insertItem(layerNames[i].c_str());
    lengthComboBox->insertItem(layerNames[i].c_str());
    slopeComboBox->insertItem(layerNames[i].c_str());
    pathsComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastDEM = settings.readEntry("lastDEM");
  QString lastBlocks = settings.readEntry("lastBlocks");
  QString lastSUB = settings.readEntry("lastSUB");
  QString lastUpLDD = settings.readEntry("lastUpLDD");
  QString lastUpACU = settings.readEntry("lastUpACU");  
  QString lastUpSUB = settings.readEntry("lastUpSUB");  
  QString lastSlope = settings.readEntry("lastSlope");
  QString lastLength = settings.readEntry("lastLength");
  QString lastPaths = settings.readEntry("lastPaths");
  QString lastCELLHIG = settings.readEntry("lastCELLHIG");
  
  int index;

  index = comboboxFind( demComboBox, lastDEM );
  demComboBox->setCurrentItem( index );

  //index = comboboxFind( blocksComboBox, lastBlocks );
  //blocksComboBox->setCurrentItem( index );

  //index = comboboxFind( highSubwatershedComboBox, lastSUB );
  //highSubwatershedComboBox->setCurrentItem( index );

  index = comboboxFind( lowLDDComboBox, lastUpLDD );
  lowLDDComboBox->setCurrentItem( index );

  index = comboboxFind( lowAccumulatedComboBox, lastUpACU );
  lowAccumulatedComboBox->setCurrentItem( index );

  index = comboboxFind( lowSubwatershedComboBox, lastUpSUB );
  lowSubwatershedComboBox->setCurrentItem( index );

  index = comboboxFind( lengthComboBox, lastLength );
  lengthComboBox->setCurrentItem( index );

  index = comboboxFind( slopeComboBox, lastSlope );
  slopeComboBox->setCurrentItem( index );

  index = comboboxFind( pathsComboBox, lastPaths );
  pathsComboBox->setCurrentItem( index );
  
  outputFileLineEdit->setText( lastCELLHIG );  

  return true;

}

void HidroCellHigWindow::outputFileToolButton_clicked()
{
  QSettings settings;
  settings.setPath( "TerraHidro.br", "Cell Hig", QSettings::User );

  QString outPath = settings.readEntry( "outFile" );  

  QString outFileName = QFileDialog::getSaveFileName(outPath,
    "HIG Files(*.hig *.HIG);;TXT Files(*.txt *.TXT);;ALL Files(*.*)",this,"Save as","File name");
	
  if (!outFileName.isEmpty())	
  {
	  outputFileLineEdit->setText(outFileName);
    QFileInfo outFile( outFileName );
    outPath = outFile.dirPath();
    settings.writeEntry( "outFile", outPath );
  }
}


void HidroCellHigWindow::destroy()
{

}