#include <HidroDEMFill.h>

#include <HidroFlowUtils.h>

#include <TeRaster.h>
#include <TePDIMatrix.hpp>
#include <TePDIInterpolator.hpp>
#include <TePDITypes.hpp>

#include <vector>


bool
HidroDEMFill::execute()
{
  // save start time
  Time::instance().start();
  timeStart_ = Time::instance().actualTimeString();

  // create output DEM raster  
  // output DEM params
  TeRasterParams outputDEMRasterParams = inputDEMRaster_->params();

  // Set format
  outputDEMRasterParams.setDataType( TeDataType::TeFLOAT );
  
  // Set dummy
  outputDEMRasterParams.setDummy( -32768 );
  outputDEMRasterParams.useDummy_ = true;  

  // Change mode
  outputDEMRasterParams.mode_ = 'w';
  outputDEMRasterParams.decoderIdentifier_ = "SMARTMEM";

  // Set Max and Minimal values
  outputDEMRasterParams.vmax_[0] = -TeMAXFLOAT;
  outputDEMRasterParams.vmin_[0] =  TeMAXFLOAT;

  // create the raster
  outputDEMRaster_ = new TeRaster( outputDEMRasterParams );

  // verify if outputDEMRaster created is valid
  if( !outputDEMRaster_->init() )
  {
    errorMessage_ = outputDEMRaster_->errorMessage();    
    timeEnd_ = Time::instance().actualTimeString();
    timeTotal_ = Time::instance().partialString();
    return false;
  }


  // Fill the void (less than zero)
  TeProgress::instance()->reset();
	TeProgress::instance()->setCaption("DEM Fill");
	TeProgress::instance()->setMessage("Step 1 from 2");
  unsigned int nlines = inputDEMRaster_->params().nlines_;
  unsigned int ncolumns = inputDEMRaster_->params().ncols_;


  double inputRasterVal;
  double referenceRasterVal;

  TePDIInterpolator interp;
  TePDITypes::TePDIRasterPtrType inputRaster(referenceDEMRaster_, true);  
  interp.reset( inputRaster, TePDIInterpolator::BilinearMethod, -32768.0 );

  for( unsigned int line=0; line<nlines; line++ )
  {
    for( unsigned int column=0; column<ncolumns; column++ )
    {
      inputDEMRaster_->getElement( column, line, inputRasterVal );
      if( inputRasterVal > 0.0 )
      {
        //set the output raster val
        outputDEMRaster_->setElement( column, line, inputRasterVal );
      }
      else
      {
        //get the input raster coordinates
        TeCoord2D inputRasterCoord = inputDEMRaster_->index2Coord( TeCoord2D(column, line) );

        //get the reference raster index
        TeCoord2D referenceRasterIndex = referenceDEMRaster_->coord2Index( inputRasterCoord );

        interp.interpolate( referenceRasterIndex.y_, referenceRasterIndex.x_, 0, referenceRasterVal );

        

        //get the reference raster value
        //if( !referenceDEMRaster_->getElement( TeRound(referenceRasterIndex.x_),
        //                                      TeRound(referenceRasterIndex.y_),
        //                                      referenceRasterVal ) )
        //{
        //  referenceRasterVal= -32768.0;
        //}

        if( referenceRasterVal < -9000 )
        {
          referenceRasterVal = -32768.0;
        }

        //set the output raster val
        outputDEMRaster_->setElement( column, line, referenceRasterVal );
      }      
    }
    // refresh progress bar    
    TeProgress::instance()->setProgress( line );
    
    // check for cancel
    if( TeProgress::instance()->wasCancelled() )
    {
      return cancel();
    }
  }

  // Finish progress bar
  TeProgress::instance()->reset();

  // save processing time
  timeEnd_ = Time::instance().actualTimeString();
  timeTotal_ = Time::instance().partialString();

  return true;
}



HidroDEMFill::HidroDEMFill(TeRaster* inputDEMRaster,
    TeRaster* referenceDEMRaster,    
    TeRaster* &outputDEMRaster ) :
    HidroFlowAlgorithm( inputDEMRaster ),
    inputDEMRaster_(inputDEMRaster),
    referenceDEMRaster_(referenceDEMRaster),    
    outputDEMRaster_(outputDEMRaster)    
{
}

HidroDEMFill::~HidroDEMFill()
{  
}

bool HidroDEMFill::cancel()
{
  return HidroFlowAlgorithm::cancel();
}
