/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_CONSISTENT_DEM_H
#define HIDRO_CONSISTENT_DEM_H

/** 
  * \file HidroConsistendDEM.h
  *
  *
  * \brief This file is a class to define the flow path of set of points.
  *
  * \author Alexandre Copertino Jardim <alexandre@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>
#include <TePDIMatrix.hpp>

#define MINIMUM_DEM_DIFFERENCE 0.1

class TeRaster;

class HidroConsistentDEM : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddRaster LDD raster (input).
    * \param demRaster DEM raster (input).    
    * \param outputDEMRaster output DEM raster (result).    
	  **/
    HidroConsistentDEM( TeRaster* lddRaster,
    TeRaster* demRaster,    
    TeRaster* &outputDEMRaster );

    ~HidroConsistentDEM();

  bool execute();

protected:
  bool cancel();

  TeRaster* lddRaster_;
  TeRaster* demRaster_;
  TeRaster* &outputDEMRaster_;  
};



#endif //HIDRO_CONSISTENT_DEM_H

