#ifndef _HIDRO_FLOW_ALGORITHM_H_
#define _HIDRO_FLOW_ALGORITHM_H_

#include <TePDIMatrix.hpp>
#include <HidroTime.h>

#include <string>

#define MATRIX_MAX_PERCENT_USAGE 5

class TeRaster;

class HidroFlowAlgorithm
{
public:
  HidroFlowAlgorithm( TeRaster* lddRaster );
  
  virtual ~HidroFlowAlgorithm();

  virtual bool execute() = 0;

  const std::string& getErrorMessage();
  
  const std::string& getTimeStart();
  const std::string& getTimeEnd();
  const std::string& getTimeTotal();

protected:

  /* \brief Init the vector lineIncrement and columnIncrement used to find
   *        a LDD element  pointed by another LDD element.
  */
  void init();
  char lineIncrement[128];
  char columnIncrement[128];

  /* \brief Find the line and column of a LDD element (element To)
            pointed by another LDD element (element From).     
     \param lineFrom Line of LDD element from.
     \param columnFrom Column of LDD element from.
     \param lineTo Line of pointed LDD element.
     \param columnTo Column of pointed LDD element.
   */
  bool lddCode2LineColumn(
      const unsigned int &lineFrom,
      const unsigned int &columnFrom,
      unsigned int &lineTo,
      unsigned int &columnTo );

  bool initConnections();

  virtual bool cancel();

  TePDIMatrix<unsigned char> lddMatrix_;

  TePDIMatrix<unsigned char> connectionsMatrix_;

  unsigned int lddNLines_;
  unsigned int lddNColumns_;

  std::string errorMessage_; //!< Inform about an error message.

  std::string timeStart_; //!< Start time of proccess.
  std::string timeEnd_; //!< End time of proccess.
  std::string timeTotal_; //!< Total time of proccess.
};

#endif