#ifndef HIDRO_GRAPH_2_RASTER_H
#define HIDRO_GRAPH_2_RASTER_H

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;
class TeLayer;

class HidroGraph2Raster : public HidroFlowAlgorithm
{
public:
  HidroGraph2Raster(
    TeRaster* lddRaster,    
    TeLayer* vertexLayer,
    TeLayer* edgeLayer,
    TeRaster* &outLDDRaster );

  bool execute();

protected:
  
  unsigned char neighborDirection_[3][3];

  bool cancel();
  
  TeRaster* lddRaster_;
  TeLayer* vertexLayer_;
  TeLayer* edgeLayer_;
  TeRaster* &outLDDRaster_;
    
  TePDIMatrix<unsigned char> outLDDMatrix_;  
};

#endif // HIDRO_GRAPH_2_RASTER_H