/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_FLOW_PATH_H
#define HIDRO_FLOW_PATH_H

/** 
  * \file HidroFlowPath.h
  *
  *
  * \brief This file is a class to define the flow path of set of points.
  *
  * \author Alexandre Copertino Jardim <alexandre@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>
#include <TePDIMatrix.hpp>

class TeRaster;
class TePointSet;
class TeDatabase;

class HidroFlowPath : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddMatrix	LDD raster (input).    
    * \param pointSet Points (input).
	  **/
  HidroFlowPath( TeRaster* lddRaster,
    TePointSet& pointSet,
    std::string& outputName,
    TeDatabase* database);
  
  //@}

  ~HidroFlowPath();

  bool execute();

protected:
  bool cancel();

  TeRaster* lddRaster_;
  TePointSet& pointSet_;
  std::string outputName_;
  TeDatabase* database_;
     
};

#endif //HIDRO_FLOW_PATH_H
