#ifndef HIDRO_GENERATE_QUEUE_STATISTICS_H
#define HIDRO_GENERATE_QUEUE_STATISTICS_H

#include <TeSingleton.h>

// Foreword declarations Qt
#include <qfile.h>
#include <qtextstream.h>

class HidroGenerateQueueStatistics : public TeSingleton<HidroGenerateQueueStatistics>
{
public:
  /** \brief Start the Queue Statistics.
   */
  void start( std::string queueStatisticsFileName, unsigned int initialQueueSize );
  
  /** \brief Update the Queue Statistics file.
   */
  void increment( unsigned int newQueueSize );

  /** \brief Update the Queue Statistics file add a Hole Problem information.
   */
  void informHoleProblem( unsigned int holeProblemNumber, unsigned int newQueueSize );

  /** \brief Finalize the Queue Statistics file.
   */
  void finsh( unsigned int newQueueSize );
  
protected:
  QFile queueStatisticsFile_;
  QTextStream queueStatisticsStream_;
};

#endif //HIDRO_GENERATE_QUEUE_STATISTICS_H