#ifndef HIDRO_PFS_H
#define HIDRO_PFS_H

// Melhor usar o define que cada caminho guardar um Double
#define BORDER_PATH_GRADIENT_ 0.0001

#include <TePDIMatrix.hpp>

#include<vector>
#include<queue>

class PathTree
{
public:
  // Contrutor padro  
  PathTree( unsigned int x, unsigned int y );

  // destrutor
  ~PathTree();

  // Coordenadas do No
  unsigned int x_;
  unsigned int y_;

  // Ponteiros para Pai e filhos
  PathTree* father_;
  std::vector<PathTree*> children_; // usei vector porque na maioria das vezes vai ter um filho s  
};

class Path
{
public:
  // Contrutor padro
  Path();

  // Contrutor
  Path( unsigned int x, unsigned int y, PathTree* father, double altimetria, unsigned int length );

  // Sobrecarga do operador < (less than) para utilizar a priority_queue
  bool operator<( const Path &rightSide ) const;   

  // Coordenadas atuais
  unsigned int x_;
  unsigned int y_;

  // Quem  o pai. Precisa saber isso para colocar na rvore de caminhos.
  PathTree* father_;  

  // Altimetria atual
  double altimetria_;

  // Tamanho do caminho
  unsigned int length_;  
};

class HidroPFS
{
public:
  HidroPFS( TePDIMatrix<double>& dem, bool hasDummy = false, double demDummy = -TeMAXFLOAT );

  // Soluciona um fosso
  bool solvePit( unsigned int x, unsigned int y );

  // Adiciona um no na rvore de caminhos
  PathTree* treeAdd( PathTree* father, unsigned int x, unsigned int y );

  // Visita um no
  void visit( unsigned int x, unsigned int y );  

  // Ajusta o DEM
  void fitDEM();

  // Verrifica se  borda, considera celulas vizinhas a Dummy como borda
  bool isBorder( unsigned int x, unsigned int y );
  
  // -- Membros
  Path priority_path_;  
  priority_queue< Path > paths_;
  TePDIMatrix<double>& dem_;  
  vector< pair<unsigned int, unsigned int> > visited_;
  deque< pair<unsigned int, unsigned int> > solution_path_;
  double pit_altimetria_;

  // Priority Tree (rvore de caminhos)
  PathTree* tree_root_;
  PathTree* tree_leaf_;  

  // -- Raster Limits
  unsigned int dem_columns_;
  unsigned int dem_lines_;
  bool hasDummy_;
  double demDummy_;
};

#endif // HIDRO_PFS_H