/*!
	\brief This is the Hidro Rivers Lenght Group.
	@defgroup hidroriverslenght The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_RIVERSL_H
#define HIDRO_RIVERSL_H
#endif //HIDRO_RIVERSL_H


#include <HidroFlowAlgorithm.h>


#include <TePDIMatrix.hpp>
#include <TeGeometry.h>
class TeRaster;

class HidroRiversLenght : public HidroFlowAlgorithm
{
public:
/**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	* \param lddRaster LDD raster.
    * \param RLRaster Rivers Lenght raster (result).
    * \param kmArea If true calculate the accumulated area in km.
**/
    HidroRiversLenght( TeRaster* lddRaster, TeRaster* drRaster,TeRaster* ctRaster, TeRaster* &RLRaster ,float LDDres,bool gen_prof, TePointSet exut,TeRaster* DEMRaster,TeRaster* SUBRaster,string outputName );

    ~HidroRiversLenght(); 
	
  
  //@}

/**
* @name Behavioral Methods
* Methods related to hidro rivers lengt behavior.
**/
//@{
/**
* \brief Rivers Lenght of LDD.	
* \return True if successful false otherwise.
**/
    bool execute();
	double get_RLenght() {return RLenght_;}
  //@}

protected:
  bool cancel();
  bool initRLMatrix();
  bool initConnections();
   
/**
* @name Attributes
* Attributes related to hidro accumulator.
**/
//@{
  TeRaster* lddRaster_;
  TeRaster* drRaster_;
  TeRaster* ctRaster_;
  TeRaster* demRaster_;
  TeRaster* &RLRaster_;
  TeRaster* DEMRaster_;
  TeRaster* SUBRaster_;
  double RLenght_;
  TePDIMatrix<short> drMatrix_;
  TePDIMatrix<long> ctMatrix_;
  TePDIMatrix<float> RLMatrix_;
  TePDIMatrix<float> DEMMatrix_;
  TePDIMatrix<float> connectionsMx_;
  TePDIMatrix<float> distMatrix_;
  TePDIMatrix<short> SUBMatrix_;
  vector<TeCoord2D> zero_start;
  TeCoord2D jusante;
  float LDDres_;
  bool generate_profile_;
  TePointSet exutorio_;
  string outputName_;
  FILE* fptxt;

//@}
};

