
/*!
	\brief This is the Hidro Flow Group.
	@defgroup hidroFlow The Group for Plugin Flow Classes.
*/

#ifndef HIDRO_SEGMENTER_H
#define HIDRO_SEGMENTER_H

/** 
  * \file HidroSegmenter.h
  *
  *
  * \brief This file is a class to segmental the drainage matrix. 
  *
  * \author Alexandre Copertino Jardim <alexcj@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroFlow
 */


#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

// forward declarations
class TeRaster;
class TePointSet;

class HidroSegmenter : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddMatrix	LDD matrix (input).
    * \param drainageMatrix	Drainage matrix (input).
    * \param segmentedMatrix Segmented matrix (result).
	  **/
    HidroSegmenter( TeRaster* lddRaster,
      TeRaster* drainageRaster,
      TeRaster* &segmentedRaster );


    ~HidroSegmenter();
  
  //@}

  /**
   * @name Behavioral Methods
	 * Methods related to hidro segmenter behavior.
	**/
	//@{

    /**
    * \brief Segmenter the drainage matrix.	
    * \return True if successful, false otherwise.
	  **/
    bool execute();    

  //@}

protected:
  /**
   * @name Internal Methods
	 * Internal Methods related to hidro segmenter behavior.
	**/
	//@{

  bool cancel();    

  //@}

  /**
   * @name Attributes
	 * Attributes related to hidro segmenter.
	**/
	//@{  
    TeRaster* lddRaster_; //!< LDD matrix matrix.
    TeRaster* drainageRaster_; //!< Drainage matrix matrix.
    TeRaster* &segmentedRaster_; //!< Segmentald matrix.

    TePDIMatrix<unsigned char> drainageMatrix_;
    TePDIMatrix<int> segmentedMatrix_; //!< Segmentald matrix.
  //@}
};

#endif //HIDRO_SEGMENTER_H

