#include <HidroSmartQueue.h>

#include <cstdlib>
#include <cstdio>

HidroSmartQueue::HidroSmartQueue()
{
  setMaxMemPercentUsage( MAXMEMPERCENTUSAGE );
}

HidroSmartQueue::~HidroSmartQueue()
{
  // libera memria dos arquivos
  while( !queue_file_.empty() )
  {
    char *name = queue_file_.front();
    remove( name );
    free( name );
    queue_file_.pop();    
  }
  // libera memria da Front
  while( !queue_front_.empty() )
  {
    int *v = queue_front_.front();
    delete[] v;
    queue_front_.pop();    
  }

  // libera memria da Back
  while( !queue_back_.empty() )
  {
    int *v = queue_back_.front();
    delete[] v;
    queue_back_.pop();    
  }
}

unsigned int 
HidroSmartQueue::setMaxMemPercentUsage( double maxMemPercentUsage )
{
  const double totalPhysMem = (double)TeGetTotalPhysicalMemory();
            
  const double totalVMem = (double)TeGetTotalVirtualMemory();
  
  const double totalMem = ( ((double)maxMemPercentUsage) / 100.0 ) *
    MIN( totalVMem, totalPhysMem );
    
  const double freeMem = MIN( totalMem, (double)TeGetFreePhysicalMemory() );

  max_ram_ = freeMem;

  max_queue_size_ = (unsigned int)MAX( 100, freeMem / ((double)(sizeof(int)*4+8) * 8) );

  return freeMem;

  /*// calcula tamanho mximo da fila em memria
  unsigned long int free_vm = MIN( TeGetFreeVirtualMemory(), TeGetTotalPhysicalMemory() );

  max_ram_  = unsigned int( (maxMemPercentUsage *  double(free_vm) ) / 100.0 );
  
  max_ram_ -= sizeof( HidroSmartQueue ); // quanto que ocupa so instanciar a HidroSmartQueue
  
  // cada elemento da minha fila ocupa 16 bytes
  // divido por 2 porque vou ter 2 filas de tamanho max_queue_size_
  max_queue_size_ = (max_ram_ / 16) / 2;
  
  return max_ram_;*/  
}

bool
HidroSmartQueue::empty()
{
  if( size() )
    return false;

  return true;
}

size_t
HidroSmartQueue::size()
{
  return queue_front_.size() + queue_back_.size() + queue_file_.size()*max_queue_size_;
}

void HidroSmartQueue::newPit( unsigned int column, unsigned int line )
{
  int *v = new int[2];
  
  v[0] = column;
  v[1] = line;  

  push( v );
}

void
HidroSmartQueue::push( int* v )
{
  // Se tem Back
  if( queue_back_.size() )
  {
    // Se Back no ta cheia
    if( queue_back_.size() < max_queue_size_ )
    {
      queue_back_.push( v );
    }
    // Se Back ta cheia
    else
    {
      copyBack2File();       
      queue_back_.push( v );
    }
  }
  else
  {
    // Se tem File
    if( !queue_file_.empty() )
    {
      queue_back_.push( v );
    }
    else
    {
      // Se Front no ta cheia
      if( queue_front_.size() < max_queue_size_ )
      {
        queue_front_.push( v );
      }
      // Se Front ta cheia
      else
      {       
        queue_back_.push( v );
      }
    }
  }
}

void
HidroSmartQueue::pop()
{
  int *v = front();
  delete[] v;

  // Se tem Front
  if( !queue_front_.empty() )
  {    
    queue_front_.pop();    
  }
  // Se tem File
  else if ( !queue_file_.empty() )
  {
    copyFile2Front();    
    queue_front_.pop();    
  }
  else
  {
    // So sobrou o Back
    queue_back_.pop();
  }
}

int*
HidroSmartQueue::front()
{
  // Se tem Front
  if( !queue_front_.empty() )
  {
    return queue_front_.front();
  }
  // Se tem File
  else if ( !queue_file_.empty() )
  {
    copyFile2Front();
    return queue_front_.front();
  }
  // So sobrou o Back
  return queue_back_.front();
}

void
HidroSmartQueue::copyBack2File()
{
  char *name = tempnam( 0, "Hidro_SmartQueue_" );
  FILE *stream = fopen( name, "wb");

  while( queue_back_.size() )
  {
    int *v = queue_back_.front();    

    putw( v[0], stream );
    putw( v[1], stream );        

    delete[] v;    
    queue_back_.pop();
  }

  fclose( stream );
  queue_file_.push( name );
}

void
HidroSmartQueue::copyFile2Front()
{
  char *name = queue_file_.front();
  FILE *stream = fopen( name, "rb");
  rewind( stream );

  for(unsigned int i=0; i<max_queue_size_; i++)
  {
    int *v = new int[2];
    v[0] = getw(stream);
    v[1] = getw(stream);       
    
    queue_front_.push( v );
  }

  fclose( stream );
  remove( name );
  free( name );

  queue_file_.pop();  
}

void
HidroSmartQueue::sendFront2Back()
{
  int *v = front();
  push( v );

  // Se tem Front
  if( !queue_front_.empty() )
  {    
    queue_front_.pop();    
  }
  // Se tem File
  else if ( !queue_file_.empty() )
  {
    copyFile2Front();    
    queue_front_.pop();    
  }
  else
  {
    // So sobrou o Back
    queue_back_.pop();
  }
}

unsigned int
HidroSmartQueue::getMaxMem()
{
  return max_ram_;
}