#ifndef HIDRO_SUBWATERSHED_H
#define HIDRO_SUBWATERSHED_H

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

#include<queue>
// forward declarations
class TeRaster;
class TePointSet;

class SubPoint
{
public:
  SubPoint();

  SubPoint( unsigned int line, unsigned int column, float accumulated );

  // Sobrecarga do operador > (greater than) para utilizar a priority_queue
  bool operator>( const SubPoint &rightSide ) const; 

  unsigned int line_;
  unsigned int column_;
  float accumulated_;
};


class HidroSubWatershed : public HidroFlowAlgorithm
{
public:
  HidroSubWatershed( TeRaster* lddRaster, TeRaster* acuRaster, TePointSet& pointSet, TeRaster* &subWatershedRaster, bool minimizeBoundingBox );

  bool execute();

protected:
  void paint(const unsigned int &lineStart,
      const unsigned int &columnStart,
      const unsigned int &lineEnd,
      const unsigned int &columnEnd,
      int subWatershedValue);

  bool cancel();

  bool compres();

  TeRaster* lddRaster_; //!< LDD raster.
  TeRaster* acuRaster_; //!< LDD raster.
  TeRaster* &subWatershedRaster_;
  TePointSet& pointSet_; //!< Batch point set.

  // fila de prioridade de exutorios
  priority_queue< SubPoint, deque<SubPoint>, greater<SubPoint> > SubPointsQueue_;

  TePDIMatrix<float> accumulatedMatrix_;
  TePDIMatrix<int> subWatershedMatrix_; //!< subwatershe matrix (result).
  TePDIMatrix<int> subWatershedMatrixCompressed_; //!< subwatershe matrix (result).

  unsigned int nlines_; //!< Number of matrixes lines.
  unsigned int ncolumns_; //!< Number of matrixes columns.  

   bool minimizeBoundingBox_;
};

#endif // HIDRO_SUBWATERSHED_H