#ifndef HIDRO_UPSCALE_RASTER_H
#define HIDRO_UPSCALE_RASTER_H

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

#include<queue>

class TeRaster;
class OutletPixel;

class HidroUpscaleRaster : public HidroFlowAlgorithm
{
public:
  HidroUpscaleRaster(
    TeRaster* lddRaster,
    TeRaster* accumulatedRaster,
    TeRaster* &scaledRaster,
    TeRaster* &outletPixelsRaster,
    int factor,
    int mufp,
    int at );

  bool execute();

protected:
  OutletPixel findOutletPixel( unsigned int line, unsigned int column );

  bool initOutletPixelsCandidates( unsigned int line, unsigned int column, priority_queue< OutletPixel, deque<OutletPixel>, greater<OutletPixel> > &outletPixelsCandidates );
  
  int calculateDistance( unsigned int line, unsigned int column,  OutletPixel &outletPixel );

  OutletPixel computeBlockAccumulatedArea( unsigned int line, unsigned int column );

  OutletPixel reFindOutletPixel( unsigned int line, unsigned int column );
  void areaThreshold( unsigned int line, unsigned int column, OutletPixel &outletPixel );

  void checkCrossing( unsigned int line, unsigned int column );
  
  void solveCross( unsigned int line1, unsigned int column1, unsigned int line2, unsigned int column2 );  

  void checkLooping( unsigned int line, unsigned int column );

  void solveLooping( unsigned int line1, unsigned int column1, unsigned int line2, unsigned int column2 );

  unsigned char neighborDirection_[3][3];

  bool upStream( const unsigned int &lineFrom,
      const unsigned int &columnFrom,
      unsigned int &lineTo,
      unsigned int &columnTo );

  bool cancel();

  TeRaster* lddRaster_;
  TeRaster* accumulatedRaster_;
  TeRaster* &scaledRaster_;
  TeRaster* &outletPixelsRaster_;
  
  int factor_;
  int mufp_;
  int at_;

  TePDIMatrix<float> accumulatedMatrix_;
  TePDIMatrix<unsigned char> scaledMatrix_;
  TePDIMatrix<unsigned char> outletPixelsMatrix_;
};

class OutletPixel
{
public:
  unsigned int line_;
  unsigned int column_;
  float accumulatedArea_;
  unsigned char ldd_;

  bool operator>( const OutletPixel &rightSide ) const;

  bool operator==( const OutletPixel &rightSide ) const;
};

#endif // HIDRO_UPSCALE_RASTER_H