#include <HidroTime.h>
#include <TeRaster.h>

HidroTime::HidroTime()
{  
}

HidroTime::~HidroTime()
{
}

bool
HidroTime::error()
{
  // Finish progress bar
  TeProgress::instance()->reset();  

  // save processing time
  timeEnd_ = Time::instance().actualTimeString();
  timeTotal_ = Time::instance().partialString();
  
  return false;
}

bool
HidroTime::cancel()
{  
  errorMessage_= "The operation was canceled by user.";
  
  // Finish progress bar
  TeProgress::instance()->reset();  

  // save processing time
  timeEnd_ = Time::instance().actualTimeString();
  timeTotal_ = Time::instance().partialString();
  
  return false;
}

const std::string& 
HidroTime::getErrorMessage()
{
  return errorMessage_;
}

const std::string& 
HidroTime::getTimeStart()
{
  return timeStart_;
}

const std::string& 
HidroTime::getTimeEnd()
{
  return timeEnd_;
}

const std::string& 
HidroTime::getTimeTotal()
{
  return timeTotal_;
}

std::string
Time::actualTimeString()
{
  time_t ltime;
  time( &ltime );
  std::string stime( ctime( &ltime ) );
  return stime;
}


std::string
Time::partialString()
{
  float duration = ((float)( clock() - start_  )) / CLOCKS_PER_SEC;  
  std::string stime;
  stime.clear();

  // se for so segundos
  if( duration < 60 )
  {
    stime.append( Te2String( duration, 2 ) );
    stime.append( " s" );
    return stime;
  }
  // se for minutos
  else if ( duration < 3600 )
  {
    int minutos = (int)duration / 60;
    duration = duration - minutos*60;
    int segundos = (int)duration;
    if( minutos < 10 )
      stime.append( "0" );
    stime.append( Te2String( minutos ) );
    stime.append( ":" );
    if( segundos < 10 )
      stime.append( "0" );
    stime.append( Te2String( segundos ) );
    //stime.append( " m:s" );
  }
  // se for horas
  else
  {
    int horas = (int)duration / 3600;
    duration = duration - horas*3600;
    int minutos = (int)duration / 60;
    duration = duration - minutos*60;
    int segundos = (int)duration;
    stime.append( Te2String( horas ) );
    stime.append( ":" );
    if( minutos < 10 )
      stime.append( "0" );
    stime.append( Te2String( minutos ) );
    stime.append( ":" );
    if( segundos < 10 )
      stime.append( "0" );
    stime.append( Te2String( segundos ) );
    //stime.append( " h:m:s" );
  }
  
  return stime;
}


void
Time::reset()
{
  start_ = clock();
  partial_ = start_;
}

void Time::start()
{
  start_ = clock();
  partial_ = start_;
}

bool Time::hasPassedOneHouer()
{
  float duration = ((float)( clock() - partial_  )) / CLOCKS_PER_SEC;

  if( duration > 3600 )
  {
    partial_ = clock();
    return true;
  }

  return false;
}