#ifndef _HIDRO_TIME_H_
#define _HIDRO_TIME_H_

#include <TeSingleton.h>
#include <iostream>
#include <string.h>

#include <ctime>

class HidroTime
{
public:
  HidroTime();
  
  virtual ~HidroTime();

  virtual bool execute() = 0;

  const std::string& getErrorMessage();
  
  const std::string& getTimeStart();
  const std::string& getTimeEnd();
  const std::string& getTimeTotal();

protected:
  bool cancel();

  bool error();
  
  std::string errorMessage_; //!< Inform about an error message.

  std::string timeStart_; //!< Start time of proccess.
  std::string timeEnd_; //!< End time of proccess.
  std::string timeTotal_; //!< Total time of proccess.
};

/**
  \brief This class is used calculate processing time.
*/
class Time : public TeSingleton<Time>
{
public:
  /**
    \brief reset the timer (same that start).
  */
  void reset();

  /**
    \brief reset the timer (same that reset).
  */
  void start();

  /**
    \brief Show how many times passed before start or reset.
  */
  std::string partialString();

  /**
    \brief Show the system time and date.
  */
  std::string actualTimeString();

  /**
    \brief Return true if passed one houer by start (reset) or last call to this function.
  */
  bool hasPassedOneHouer();

protected:
  clock_t start_;
  clock_t partial_;
};

#endif // _HIDRO_TIME_H_