/*!
	\brief This is the Hidro MGB Group.
	@defgroup hidroMGB The Group for Plugin MGB Classes.
*/

#ifndef HIDRO_CROSS_SECTION_BOTTOM_LEVEL_H
#define HIDRO_CROSS_SECTION_BOTTOM_LEVEL_H

/** 
  * \file HidroCrossSectionBottomLevel.h
  *
  *
  * \brief This file is a class extract the drainage of a accumulated raster and VDNP raster.
  *
  * \author Alexandre Copertino Jardim <alexandre@dpi.inpe.br>
  * \version 1.0
  *
/*!
  @ingroup hidroMGB
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroFlowAlgorithm.h>
#include <TePDIMatrix.hpp>

class TeRaster;

class HidroCrossSectionBottomLevel : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddRaster LDD raster (input).
    * \param demRaster DEM raster (input).
    * \param contributingAreaRaster ACU raster (input).
    * \param outputDEMRaster output DEM raster (result).
    
    * \param line Accumulated Threshold (input).
    * \param column VDNP raster (input).
    * \param alpha VDNP Threshold (input).
    * \param theta Accumulated Threshold (input).
    * \param thetam Accumulated Threshold (input).
    * \param thetac Accumulated Threshold (input).
	  **/
    HidroCrossSectionBottomLevel( TeRaster* lddRaster,
    TeRaster* demRaster,
    TeRaster* contributingAreaRaster,
    TeRaster* pathsRaster,
    TeRaster* &outputDEMRaster,
    unsigned int line,
    unsigned int column,
    float outletContributingArea,
    unsigned int interactions,
    float alpha,
    float beta,
    float theta,
    float thetam,
    float thetac );

    ~HidroCrossSectionBottomLevel();

  bool execute();

protected:
  bool cancel();

  TeRaster* lddRaster_;
  TeRaster* demRaster_;  
  TeRaster* contributingAreaRaster_;
  TeRaster* pathsRaster_;
  TeRaster* &outputDEMRaster_;

  unsigned int line_;
  unsigned int column_;
  float outletContributingArea_;
  unsigned int interactions_;
  float alpha_;
  float beta_;
  float theta_;
  float thetam_;
  float thetac_; 

  //TePDIMatrix<float> contributingAreaMatrix_;
  TePDIMatrix<int> pathsMatrix_;
  //TePDIMatrix<float> outputDEMMatrix_;
};



#endif //HIDRO_CROSS_SECTION_BOTTOM_LEVEL_H

