#ifndef _HIDRO_HYDROLOGICAL_VARIABLES_H_
#define _HIDRO_HYDROLOGICAL_VARIABLES_H_

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;
class HidroHydrologicalVariables : public HidroFlowAlgorithm

{
public:
  HidroHydrologicalVariables( TeRaster* lddRaster, TeRaster* demRaster, TeRaster* drainRaster, TeRaster* *rasterpoint, bool* flagVariables, unsigned int* options );

  ~HidroHydrologicalVariables();

  bool execute();

protected:

  bool cancel();
  void HidroHydrologicalVariables::AreaCalcMatrix();
  bool HidroHydrologicalVariables::Accumulation();
  bool HidroHydrologicalVariables::lddCode2LineColumnSteps( const unsigned int &lineFrom, const unsigned int &columnFrom, unsigned int &lineTo, unsigned int &columnTo, const unsigned int &steps );
  unsigned int HidroHydrologicalVariables::lddCode2LineColumnVec( const unsigned int &lineIni, const unsigned int &columnIni, const unsigned int &steps, vector <unsigned int> &linesVec, vector <unsigned int> &columnsVec );
  bool HidroHydrologicalVariables::MaximumOrderCalcMatrix( const unsigned int &option );

  TeRaster* lddRaster_;
  TeRaster* demRaster_;
  TeRaster* drainRaster_;
  TeRaster* *rasterpoint_;
  bool* flagVariables_;
  unsigned int *options_;

  TePDIMatrix<float> demMatrix_;
  TePDIMatrix<unsigned char> drainMatrix_;
  TePDIMatrix<float> varMatrix_;
  TePDIMatrix<unsigned char> varMatrixb_;

};

#endif //_HIDRO_HYDROLOGICAL_VARIABLES_H_