#ifndef _HIDRO_VDNP_H_
#define _HIDRO_VDNP_H_

#include <HidroFlowAlgorithm.h>

#include <TePDIMatrix.hpp>

class TeRaster;

class HidroVDNP : public HidroFlowAlgorithm
{
public:
  HidroVDNP( 
    TeRaster* demRaster,
    TeRaster* lddRaster,    
    TeRaster* &vdnpRaster );

  ~HidroVDNP();

  bool execute();

protected:
  bool cancel();

  TeRaster* demRaster_;
  TeRaster* lddRaster_;
  TeRaster* &vdnpRaster_;

  TePDIMatrix<float> demMatrix_;
  TePDIMatrix<float> vdnpMatrix_;
};

#endif
