// The value zero is valid value of altimetria. Because this reason, zero is not a good value for no data value.
// Normally altimetria data like ASTER use zero value of altimetria in ocean areas. 
// For TerraHidro would better that the value of atimetria in ocean areas were an invalid value of altimetria, for example, -9999.
// This program change the no data value (dummy value) around the raster from X value to Y ignoring the zeros inside the land areas.
// Normally the X value is 0 and Y value is -9999

#include <TeDatabase.h>
#include <TePostgreSQL.h>
#include <TeInitRasterDecoders.h>
#include <TeImportRaster.h>

#include <HidroTestProgress.h>
#include <HidroTestUtils.h>

bool checkNeighborhood( unsigned int column, unsigned int line, TeRaster* outputRaster );


int main()
{
  // Parameters
  std::string inputRasterLayerName = "teste_1_s11w037";
  std::string outputRasterLayerName = "output_t3";
  int oceanValue = 0;
  int dummyValue = -9999;  

	// Initialize the raster decoder tool
	TeInitRasterDecoders();

  // Connect to the database
  // Database server parameters
  string host = "localhost";
  string dbname = "findOcean";
  string user = "postgres";
  string password = "postgres";

  // Connect to the database
  TeDatabase* db = new TePostgreSQL();
  if (!db->connect(host, user, password, dbname))
  {
    cout << "Error: " << db->errorMessage() << endl;
    cout << "Press Enter...";
    getchar();
    return false;
  }

  // Open the DEM input Raster
  HidroTestUtils utils( db );
  
  TeLayer* inputDEMLayer = NULL;
	inputDEMLayer = utils.getLayerByName( inputRasterLayerName );
  TeRaster* inputDEMRaster = NULL;
  inputDEMRaster = inputDEMLayer->raster();

  // Create the DEM output Raster  
  // blocksRaster params
  TeRasterParams outputRasterParams = inputDEMRaster->params();
  
  // Set dummy
  outputRasterParams.setDummy( (double)dummyValue );
  outputRasterParams.useDummy_ = true;  

  // Change mode
  outputRasterParams.mode_ = 'w';
  outputRasterParams.decoderIdentifier_ = "SMARTMEM";
  //outputRasterParams.setDataType( TeINTEGER );

  // Set Max and Minimal values
  outputRasterParams.vmax_[0] = -TeMAXFLOAT;
  outputRasterParams.vmin_[0] =  TeMAXFLOAT;

  // create the raster
  TeRaster* outputDEMRaster = new TeRaster( outputRasterParams );

  // verify if output DEM raster created is valid
  if( !outputDEMRaster->init() )
  {
    cout << "Error: " << outputDEMRaster->errorMessage() << endl;
    cout << "Press Enter...";
    getchar();
    return false;
  }

  // used in for's and progress bar
  unsigned int nlines = outputDEMRaster->params().nlines_;
  unsigned int ncolumns = outputDEMRaster->params().ncols_;

  unsigned int line;
  unsigned int column;

  double altimetria;

  for( line = 0; line < nlines; line++ )
  {
    for( column = 0; column < ncolumns; column++ )
    {
      inputDEMRaster->getElement(column, line, altimetria );
      outputDEMRaster->setElement(column, line, altimetria );
    }
  }

  //*
  // First step the borders
  // If some "oceanValue" in the border chage it to dummyValue  
  // Bouth columns
  for( line = 0; line < nlines; line++ )
  {
    // first column
    inputDEMRaster->getElement( 0, line, altimetria );
    if( altimetria == 0 )
    {
      outputDEMRaster->setElement( 0 , line, (double)dummyValue );
    }
    else
    {
      outputDEMRaster->setElement( 0 , line, altimetria );
    }

    // last column
    inputDEMRaster->getElement( ncolumns - 1, line, altimetria );
    if( altimetria == 0 )
    {
      outputDEMRaster->setElement( ncolumns - 1 , line, (double)dummyValue );
    }
    else
    {
      outputDEMRaster->setElement( ncolumns - 1 , line, altimetria );
    }    
  }

  // Bouth lines
  for( column = 0; column < ncolumns; column++ )
  {
    // first line
    inputDEMRaster->getElement( column, 0, altimetria );
    if( altimetria == 0 )
    {
      outputDEMRaster->setElement( column, 0, (double)dummyValue );
    }
    else
    {
      outputDEMRaster->setElement( column, 0, altimetria );
    }

    // last line
    inputDEMRaster->getElement( column, line - 1, altimetria );
    if( altimetria == 0 )
    {
      outputDEMRaster->setElement( column, line - 1, (double)dummyValue );
    }
    else
    {
      outputDEMRaster->setElement( column, line - 1, altimetria );
    }    
  }/**/
  /*unsigned int nc = ncolumns - 2;
  unsigned int nl = nlines - 2;
  unsigned int c = 1;
  unsigned int l = 1;
  unsigned int cc = ncolumns/2;
  unsigned int lc = nlines/2;
  unsigned int i;
 
  
  /*while ( c < nc || l < nl )
  {
    // first line
    for( i = c; i < nc; i++ )
    {
      outputDEMRaster->getElement( i, l, altimetria );
      if( (int)altimetria == oceanValue )
      {
        if( checkNeighborhood( i, l, outputDEMRaster ) )
        {
          outputDEMRaster->setElement( i , l, (double)dummyValue );
        }
      }      
    }

    // last line    
    for( i = c; i < nc; i++ )
    {
      outputDEMRaster->getElement( i, nl-1, altimetria );
      if( (int)altimetria == oceanValue )
      if( checkNeighborhood( i, nl-1, outputDEMRaster ) )
      {
        outputDEMRaster->setElement( i , nl-1, (double)dummyValue );
      }
      //else
      //{
      //  outputDEMRaster->setElement( i , nl-1, altimetria );
      //}
    }

    // first column
    for( i = l; i < nl; i++ )
    {
      outputDEMRaster->getElement( c, i, altimetria );
      if( (int)altimetria == oceanValue )
      if( checkNeighborhood( c, i, outputDEMRaster ) )
      {
        outputDEMRaster->setElement( c , i, (double)dummyValue );
      }
      //else
      //{
      //  outputDEMRaster->setElement( c , i, altimetria );
      //}
    }


    // last column
    for( i = l; i < nl; i++ )
    {
      outputDEMRaster->getElement( nc-1, i, altimetria );
      if( (int)altimetria == oceanValue )
      if( checkNeighborhood( nc-1, i, outputDEMRaster ) )
      {
        outputDEMRaster->setElement( nc-1 , i, (double)dummyValue );
      }      
    }

    l++;
    c++;
    nl--;
    nc--;
  }/**/

  
  //for( unsigned int j = nc; nc > 0; nc-- )
  unsigned int total;
  if( nlines > ncolumns )
  {
    total = nlines;
  }
  else
  {
    total = ncolumns;
  }

  unsigned int j, i;
  double altimetriaLast;
    
  for( j = 1; j < total; j++ )
  {
    // last lines
    for( i = 1; i < ncolumns-1; i++ )
    {
      outputDEMRaster->getElement( i, j, altimetria );
      outputDEMRaster->getElement( i, j-1, altimetriaLast );
      if( (int)altimetria == oceanValue )
      {
        if( (int)altimetriaLast == dummyValue )
        //if( checkNeighborhood( i, j, outputDEMRaster ) )
        {
          outputDEMRaster->setElement( i, j, (double)dummyValue );
        }
      }
    }

    // first columns
    for( i = 1; i < nlines-1; i++ )
    {
      outputDEMRaster->getElement( j, i, altimetria );
      outputDEMRaster->getElement( j-1, i, altimetriaLast );
      if( (int)altimetria == oceanValue )
      {
        if( (int)altimetriaLast == dummyValue )
        //if( checkNeighborhood(  j, i, outputDEMRaster ) )
        {
          outputDEMRaster->setElement( j , i, (double)dummyValue );
        }
      }
    }

    // last columns
    for( i = 1; i < nlines-1; i++ )
    {
      outputDEMRaster->getElement( ncolumns-1-j, i, altimetria );
      outputDEMRaster->getElement( ncolumns-j, i, altimetriaLast );
      if( (int)altimetria == oceanValue )
      {
        if( (int)altimetriaLast == dummyValue )
        //if( checkNeighborhood(  ncolumns-1-j, i, outputDEMRaster ) )
        {
          outputDEMRaster->setElement( ncolumns-1-j , i, (double)dummyValue );
        }
      }
    }

    // last lines
    for( i = 1; i < ncolumns-1; i++ )
    {
      outputDEMRaster->getElement( i, nlines-1-j, altimetria );
      outputDEMRaster->getElement( i, nlines-j, altimetriaLast );
      if( (int)altimetria == oceanValue )
      {
        if( (int)altimetriaLast == dummyValue )
        //if( checkNeighborhood( i, nlines-1-j, outputDEMRaster ) )
        {
          outputDEMRaster->setElement( i, nlines-1-j, (double)dummyValue );
        }
      }
    }   

  }

  // save the raster in database
  // Check whether there is a layer with this name in the database
	if( db->layerExist( outputRasterLayerName ) )
	{		
		cout << "The database already has an infolayer with the name \"";
		cout << outputRasterLayerName << "\"!" << endl << endl;		
		return false;
	}

  // Create the layer
	TeLayer* layer = new TeLayer( outputRasterLayerName, db, outputDEMRaster->projection() );
	if (layer->id() <= 0)
	{		
		cout << "The destination layer \"" << outputRasterLayerName << "\" could not be created!\n" << db->errorMessage() << endl;		
		return false;
	}

	// Import the DEM image to the layer
  if( !TeImportRaster( layer, outputDEMRaster, 512, 512, TeRasterParams::TeNoCompression, "", dummyValue, true, TeRasterParams::TeNoExpansible ) )
	{		
		cout << "Fail to import the raster to layer\"" << outputRasterLayerName << "\".\n\n!";		
		return false;
	}

  cout << "Successful!" << endl;
  cout << "Press enter...";
	getchar();
	return true;
}



bool checkNeighborhood( unsigned int column, unsigned int line, TeRaster* outputDEMRaster )
{
  // Dont check the diagonals
  double altimetria;
  int dummyValue = -9999; 
  
  // up
  outputDEMRaster->getElement( column, line-1, altimetria );
  if( (int)altimetria  ==  dummyValue  )
  {
    return true;
  }


  // letf
  outputDEMRaster->getElement( column+1, line, altimetria );
  if( (int)altimetria  ==  dummyValue  )
  {
    return true;
  }

  // down
  outputDEMRaster->getElement( column, line+1, altimetria );
  if( (int)altimetria  ==  dummyValue  )
  {
    return true;
  }

  // rigth
  outputDEMRaster->getElement( column-1, line, altimetria );
  if( (int)altimetria  ==  dummyValue  )
  {
    return true;
  }


  return false;
}