/******************************************************************************
* Hidro development team
* 
* Terra View Hidro Plugin
* 
* @(#) HidroBoostUIConnectedComponents.h
*
*******************************************************************************
*
* $Rev: 8870 $:
*
* $Author: alexcj $:
*
* $Date: 2010-08-30 09:18:11 -0300 (seg, 30 ago 2010) $:
*
******************************************************************************/

/*!
	\brief This is the Hidro Interfaces Group.
	@defgroup hidroInterface The Group for Plugin Interaction.
*/

/** 
  * \file HidroBoostUIConnectedComponents.ui.h
  *
  * \class HidroBoostUIConnectedComponents
  *
  * \brief This file is a interface generated by qt designer
  *
  * This interface defines the Boost algorithm Connected Components.
  *		To execute this operation is necessary:
  *												select a hidro graph.
  *
  * \sa HidroMainWindow.ui.h
  *
  * \author Eric Silva Abreu <eric.abreu@funcate.org.br>
  * \version 1.0
  *
/*!
  @ingroup hidroInterface
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/

#include <HidroPersister.h>
#include <HidroBoostUtils.h>
#include <HidroBoostParams.h>
#include <HidroBoostAlgorithmFactory.h>

#include <qmessagebox.h>

#include <TeUtils.h>

/** \brief HidroBoostUIConnectedComponents init function.
    * Used to replace de default constructor from interface;
	* \param parameters		Input parameter used to set the parameters from app
	* \return				True if the input parameters are valids and False in other case.
    */
bool HidroBoostUIConnectedComponents::init( PluginParameters* parameters, bool directGraph  )
{
    if(parameters == NULL)
	{
		return false;
	}

	_parameters = parameters;

	_directGraph = directGraph;

	if(_directGraph)
	{
		textLabelTitle->setText(tr("Allow execute Strongly Connected Components from BGL..."));
		groupBoxGraph->setTitle(tr("Selected Directed Graph"));
		textLabelResult->setText(tr("Number of Strongly Connected Components:"));
	}

	return true;
}

/** \brief HidroBoostUIConnectedComponents set graph name function.
    * Used to set the graph name selected by user to apply this algorithm
	* \param graphName		Input parameter used to define the hidro graph selected
    */
void HidroBoostUIConnectedComponents::setGraphName( const std::string & graphName )
{
	if(!graphName.empty())
	{
		graphNameLineEdit->setText(graphName.c_str());
	}
}

/** \brief HidroBoostUIConnectedComponents Ok function.
    * Used to execute the operation.
    */
void HidroBoostUIConnectedComponents::okPushButton_clicked()
{
	if(graphNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Graph name not defined."));
		return;
	}

//load graph from database
	HidroGraph graph;

	HidroPersister persister(_parameters->getCurrentDatabasePtr());
	if(!persister.loadGraphFromDatabase(graphNameLineEdit->text().latin1(), graph))
	{
		QMessageBox::warning(this, tr("Warning"), persister.getErrorMessage().c_str());
		return;
	}

//execute algorithm
	HidroBoostParams pBoost;

	pBoost._inputHidroGraph = &graph;
	
	if(_directGraph)
	{
		pBoost._boostAlgorithmName = "Strongly Connected Components";
	}
	else
	{
		pBoost._boostAlgorithmName = "Connected Components";
	}
	
	HidroBoostAlgorithms* aBoost = HidroBoostAlgorithmFactory::make(pBoost);

	if(aBoost)
	{
		if(!aBoost->executeAlgorithm())
		{
			std::string errorMessage = aBoost->_errorMessage;
			QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());

			delete aBoost;

			return;
		}
	}
	else
	{
		QMessageBox::warning(this, tr("Warning"), tr("Boost Algorithm not found."));
		return;
	}

	HidroBoostParams outPBoost;
	aBoost->getParameters(outPBoost);

	std::string value = Te2String(outPBoost._returnIntValue);

	componentsNumberLineEdit->setText(value.c_str());

	delete aBoost;

	QMessageBox::warning(this, tr("Warning"), tr("Algorithm executed."));
}

/*
** ----------------------------------------------------------------------------
** End:
*/
