/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroCrossSectionBottomLevelWindow.h>

#include <HidroCrossSectionBottomLevel.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qsettings.h>
#include <qcombobox.h>


void HidroCrossSectionBottomLevelWindow::runPushButton_clicked()
{
  // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // LDD
  if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD layer not defined."));
		return;
	}
  // Contributing Area
  if(contributingAreaComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Contributing Area layer not defined."));
		return;
	}
  // DEM
  if(demGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}
  // Paths
  if(pathsComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Paths layer not defined."));
		return;
	}

  
  if(lineLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Line not defined."));
		return;
  }
  if(coumnLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Column not defined."));
		return;
  }
  if(alphaLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Alpha not defined."));
		return;
  }
  if(betaLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Beta not defined."));
		return;
  }
  if(thetaLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Theta not defined."));
		return;
  }
  if(thetamLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Thetam not defined."));
		return;
  }
  if(thetacLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Thetac not defined."));
		return;
  }  

  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Output name (base layer  name)
	if(demGridLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output DEM name not defined."));
		return;
	}
  if(!utils.checkLayerName(demGridLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}	 

  // open input raster's
  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();

  // Contributing Area
  TeLayer* contributingAreaLayer = NULL;
	contributingAreaLayer = utils.getLayerByName( contributingAreaComboBox->currentText().latin1() );
  TeRaster* contributingAreaRaster = NULL;
  contributingAreaRaster = contributingAreaLayer->raster();

  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demGridComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // Paths
  TeLayer* pathsLayer = NULL;
	pathsLayer = utils.getLayerByName( pathsComboBox->currentText().latin1() );
  TeRaster* pathsRaster = NULL;
  pathsRaster = pathsLayer->raster();

  // Parameters
  unsigned int line = lineLineEdit->text().toUInt();
  unsigned int column = coumnLineEdit->text().toUInt();
  float outletContributingArea = outletContributingArealineEdit->text().toFloat();
  unsigned int interactions = interactionsLineEdit->text().toUInt();
  float alpha = alphaLineEdit->text().toFloat();
  float beta = betaLineEdit->text().toFloat();
  float theta = thetaLineEdit->text().toFloat();
  float thetam = thetamLineEdit->text().toFloat();
  float thetac = thetacLineEdit->text().toFloat();

  // output raster
  TeRaster* outputDEMRaster = NULL;

  // Drainage Extraction
  HidroCrossSectionBottomLevel crossSectionBottomLevel( lddRaster,
    demRaster,
    contributingAreaRaster,
    pathsRaster,
    outputDEMRaster,
    line,
    column,
    outletContributingArea,
    interactions,
    alpha,
    beta,
    theta,
    thetam,
    thetac );

  // execut the algorithm
  if( !crossSectionBottomLevel.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(crossSectionBottomLevel.getErrorMessage().c_str()));
    
    if( outputDEMRaster )
    {
      delete outputDEMRaster;
    }
    
    return;
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastLDD", flowGridComboBox->currentText() );
  settings.writeEntry( "lastDEM", demGridComboBox->currentText() );
  settings.writeEntry( "lastACU", contributingAreaComboBox->currentText() );
  settings.writeEntry( "lastPaths", pathsComboBox->currentText() );
  
  settings.writeEntry( "lastOutletContributingArea", outletContributingArealineEdit->text() );
  settings.writeEntry("lastInteractions", interactionsLineEdit->text());
  settings.writeEntry( "lastAlpha", alphaLineEdit->text() );
  settings.writeEntry( "lastBeta", betaLineEdit->text() );
  settings.writeEntry( "lastTheta", thetaLineEdit->text() );
  settings.writeEntry( "lastThetam", thetamLineEdit->text() );
  settings.writeEntry( "lastThetac", thetacLineEdit->text() );
  
  // import result to database
  TeProgress::instance()->setMessage("Saving Drainage Raster into database.");
  utils.saveOutputRaster( demGridLineEdit->text().latin1(), outputDEMRaster );

  // create theme  
  TeLayer* outputDEMLayer = NULL;
	outputDEMLayer = utils.getLayerByName( demGridLineEdit->text().latin1() );
  if( view )
  {
    utils.rasterTheme( view, outputDEMLayer );
  }

  // update the TerraView interface
	parameters_->updateTVInterface();

  // close the window
  //accept(); 

  // informe the successful process
  QString message;
  message.append("Cross Section Bottom Level\n");
  message.append("Start Time: ");
  message.append( crossSectionBottomLevel.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( crossSectionBottomLevel.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( crossSectionBottomLevel.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );
}


bool HidroCrossSectionBottomLevelWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  flowGridComboBox->clear();
  flowGridComboBox->insertItem("");

  demGridComboBox->clear();
	demGridComboBox->insertItem("");

  contributingAreaComboBox->clear();
	contributingAreaComboBox->insertItem("");  

  pathsComboBox->clear();
	pathsComboBox->insertItem("");  

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{		
    flowGridComboBox->insertItem(layerNames[i].c_str());
    demGridComboBox->insertItem(layerNames[i].c_str());
    contributingAreaComboBox->insertItem(layerNames[i].c_str());    
    pathsComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastLDD = settings.readEntry("lastLDD");
  QString lastACU = settings.readEntry("lastACU");
  QString lastDEM = settings.readEntry("lastDEM");
  QString lastPaths = settings.readEntry("lastPaths");
    
  QString lastOutletContributingArea = settings.readEntry( "lastOutletContributingArea" );
  QString lastInteractions = settings.readEntry("lastInteractions");
  QString lastAlpha = settings.readEntry("lastAlpha");
  QString lastBeta = settings.readEntry("lastBeta");
  QString lastTheta = settings.readEntry("lastTheta");
  QString lastThetam = settings.readEntry("lastThetam");
  QString lastThetac = settings.readEntry("lastThetac");
   
  int index;  

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  index = comboboxFind( demGridComboBox, lastDEM );
  demGridComboBox->setCurrentItem( index );

  index = comboboxFind( contributingAreaComboBox, lastACU );
  contributingAreaComboBox->setCurrentItem( index );

  index = comboboxFind( pathsComboBox, lastPaths );
  pathsComboBox->setCurrentItem( index );
  
  outletContributingArealineEdit->setText( lastOutletContributingArea );
  alphaLineEdit->setText( lastAlpha );
  betaLineEdit->setText( lastBeta );
  thetaLineEdit ->setText( lastTheta );
  thetamLineEdit->setText( lastThetam );
  thetacLineEdit->setText( lastThetac );

  return true;
}
