/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


#include <HidroDEMFillWindow.h>

#include <HidroDEMFill.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qsettings.h>
#include <qcombobox.h>

void HidroDEMFillWindow::runPushButton_clicked()
{
    // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // LDD
  if(inputDEMComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}  
  // DEM
  if(referenceDEMComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Reference DEM layer not defined."));
		return;
	}


  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Output name (base layer  name)
	if(outputDEMLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output DEM name not defined."));
		return;
	}
  if(!utils.checkLayerName(outputDEMLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}	 

  // open input raster's
  // LDD
  TeLayer* inputDEMLayer = NULL;
	inputDEMLayer = utils.getLayerByName( inputDEMComboBox->currentText().latin1() );
  TeRaster* inputDEMRaster = NULL;
  inputDEMRaster = inputDEMLayer->raster();  

  // DEM
  TeLayer* referenceDEMLayer = NULL;
	referenceDEMLayer = utils.getLayerByName( referenceDEMComboBox->currentText().latin1() );
  TeRaster* referenceDEMRaster = NULL;
  referenceDEMRaster = referenceDEMLayer->raster();

  // output raster
  TeRaster* outputDEMRaster = NULL;

  // Drainage Extraction
  HidroDEMFill demFill( inputDEMRaster,
    referenceDEMRaster,    
    outputDEMRaster);

  // execut the algorithm
  if( !demFill.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(demFill.getErrorMessage().c_str()));
    
    if( outputDEMRaster )
    {
      delete outputDEMRaster;
    }
    
    return;
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastDEM", inputDEMComboBox->currentText() );
  settings.writeEntry( "lastReferenceDEM", referenceDEMComboBox->currentText() );
   
  // import result to database
  TeProgress::instance()->setMessage("Saving DEM Raster into database.");
  utils.saveOutputRaster( outputDEMLineEdit->text().latin1(), outputDEMRaster );

  // create theme  
  TeLayer* outputDEMLayer = NULL;
	outputDEMLayer = utils.getLayerByName( outputDEMLineEdit->text().latin1() );
  if( view )
  {
    utils.rasterTheme( view, outputDEMLayer );
  }

  // update the TerraView interface
	parameters_->updateTVInterface();

  // close the window
  //accept(); 

  // informe the successful process
  QString message;
  message.append("DEM Fill\n");
  message.append("Start Time: ");
  message.append( demFill.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( demFill.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( demFill.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );
}


bool HidroDEMFillWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  inputDEMComboBox->clear();
  inputDEMComboBox->insertItem("");

  referenceDEMComboBox->clear();
	referenceDEMComboBox->insertItem("");  

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{		
    inputDEMComboBox->insertItem(layerNames[i].c_str());
    referenceDEMComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastDEM = settings.readEntry("lastDEM"); 
  QString lastReferenceDEM = settings.readEntry("lastReferenceDEM");  
   
  int index;  

  index = comboboxFind( inputDEMComboBox, lastDEM );
  inputDEMComboBox->setCurrentItem( index );

  index = comboboxFind( referenceDEMComboBox, lastReferenceDEM );
  referenceDEMComboBox->setCurrentItem( index );
  return true;
}





