/******************************************************************************
* Hidro development team
* 
* Terra View Hidro Plugin
* 
* @(#) HidroEditionWindow.h
*
*******************************************************************************
*
* $Rev: 8870 $:
*
* $Author: alexcj $:
*
* $Date: 2010-08-30 09:18:11 -0300 (seg, 30 ago 2010) $:
*
******************************************************************************/

/*!
	\brief This is the Hidro Interfaces Group.
	@defgroup hidroInterface The Group for Plugin Interaction.
*/

/** 
  * \file HidroEditionWindow.ui.h
  *
  * \class HidroEditionWindow
  *
  * \brief This file is a interface generated by qt designer
  *
  * This interface is the edition interface from hidro application, 
  * will be used to edit graphs (add and remove vertex, adge, change and remove edges). 
  *
  *
  * \author Eric Silva Abreu <eric.abreu@funcate.org.br>
  * \version 1.0
  *
/*!
  @ingroup hidroInterface
 */

/*
** ----------------------------------------------------------------------------
** Includes:
*/
#include <HidroMetadata.h>
#include <HidroUtils.h>
#include <HidroVertexEdition.h>
#include <HidroEdgeEdition.h>

#include <TeQtViewsListView.h>
#include <TeQtViewItem.h>
#include <TeQtThemeItem.h>
#include <TeQtCanvas.h>

#include <qmessagebox.h>

/** \brief HidroEditionWindow init function.
    * Used to replace de default constructor from interface;
	* \param parameters		Input parameter used to set the parameters from app
	* \return				True if the input parameters are valids and False in other case.
    */
bool HidroEditionWindow::init( PluginParameters* parameters )
{
    if(parameters == NULL)
	{
		return false;
	}

	_parameters = parameters;

	_vertexTheme = NULL;
	_edgeTheme = NULL;

	_optEdWindow = NULL;

	editTabWidget->setDisabled(true);

//list all graphs from current database
	listGraphs();

//set off all tools
	releaseTools();

	return true;
}


/** \brief HidroEditionWindow destroy function.
    * Used to replace de default destructor from interface;
    */
void HidroEditionWindow::destroy()
{
	if(_optEdWindow)
	{
		delete _optEdWindow;
		_optEdWindow = NULL;
	}
}

/** \brief HidroEditionWindow graphNameComboBox activated.
    * Used to select a graph given a list with all graphs from current database
	* \param value		Input parameter, used to define the graph name selected by user
    */
void HidroEditionWindow::graphNameComboBox_activated( const QString & value )
{
	vertexLayerLineEdit->setText("");
	edgeLayerLineEdit->setText("");

	if(value.isEmpty())
	{
//disabable edition
		editTabWidget->setDisabled(true);
		return;
	}

	HidroMetadata metadata(_parameters->getCurrentDatabasePtr());

	TeLayer* vertexLayer	= metadata.getGraphLayerPoints(value.latin1());
	TeLayer* edgeLayer		= metadata.getGraphLayerLines(value.latin1());

	if(!vertexLayer || !edgeLayer)
	{
//graph layers not found
		editTabWidget->setDisabled(true);

		QMessageBox::warning(this, tr("Warning"), tr("Layers from graph not found."));
		return;
	}

//inform in interface the graph layer names
	vertexLayerLineEdit->setText(vertexLayer->name().c_str());
	edgeLayerLineEdit->setText(edgeLayer->name().c_str());

//get themes from graph
	listThemes();
}

/** \brief HidroEditionWindow Add Vertex by Click.
    * Used to define that a new vertex will be created by click on canvas
    */
void HidroEditionWindow::addVertexByClickRadioButton_clicked()
{
	releaseTools();

	_addVertex = true;

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addVertexXCoordLineEdit->setDisabled(true);
	addVertexYCoordLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Add Vertex by Coord.
    * Used to define that a new vertex will be created by coord inserted on interface
    */
void HidroEditionWindow::addVertexByCoordRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addVertexXCoordLineEdit->setDisabled(false);
	addVertexYCoordLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Add Vertex Execute.
    * Used to create a new vertex defined by user on interface
    */
void HidroEditionWindow::addVertexPushButton_clicked()
{
	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	if(addVertexXCoordLineEdit->text().isEmpty() || addVertexYCoordLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex coord is not defined."));
		return;
	}

	if(vertexNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex name is not defined."));
		return;
	}
	std::string vertexName = vertexNameLineEdit->text().latin1();

	/*if(addVertexAttrTable->numRows() == 0)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex attributes is not defined."));
		return;
	}*/

//get attributes
	std::vector<std::string> attrs;
	for(int i = 0; i < addVertexAttrTable->numRows(); ++i)
	{
		attrs.push_back(addVertexAttrTable->text(i, 1).latin1());
	}

	TeTheme* theme = dynamic_cast<TeTheme*>(_vertexTheme->getTheme());

//execute
	HidroVertexEdition edition(theme, _parameters->teqtgrid_ptr_);
	if(!edition.addVertex(	addVertexXCoordLineEdit->text().toDouble(), 
							addVertexYCoordLineEdit->text().toDouble(), 
							attrs, vertexName))
	{
		QMessageBox::warning(this, tr("Warning"), edition.getErrorMessage().c_str());
		return;
	}

	_parameters->plotTVData();

	QMessageBox::warning(this, tr("Warning"), tr("Vertex added correctly."));
}

/** \brief HidroEditionWindow Remove Vertex by Click.
    * Used to define the  vertex that will be removed by click on canvas
    */
void HidroEditionWindow::removeVertexByClickRadioButton_clicked()
{
	releaseTools();

    _removeVertex = true;

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	removeVertexIdentLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Remove Vertex by Identification.
    * Used to define the  vertex that will be removed by id defined on interface
    */
void HidroEditionWindow::removeVertexByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	removeVertexIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Remove Vertex Execute.
    * Used to remove a vertex defined by user on interface
    */
void HidroEditionWindow::removeVertexPushButton_clicked()
{
	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	if(removeVertexIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex not defined."));
		return;
	}

	TeTheme* theme = dynamic_cast<TeTheme*>(_vertexTheme->getTheme());

//execute
	HidroMetadata metadata(_parameters->getCurrentDatabasePtr());
	TeLayer* edgeLayer = metadata.getGraphLayerLines(graphNameComboBox->currentText().latin1());
	std::string edgeTable = edgeLayer->attrTables()[0].name();

	HidroVertexEdition edition(theme, _parameters->teqtgrid_ptr_);
	if(!edition.removeVertex(removeVertexIdentLineEdit->text().latin1(), edgeTable))
	{
		QMessageBox::warning(this, tr("Warning"), edition.getErrorMessage().c_str());
		return;
	}

	_parameters->plotTVData();

	QMessageBox::warning(this, tr("Warning"), tr("Vertex removed correctly."));
}

/** \brief HidroEditionWindow Add Edge From by click.
    * Used to create a new edge and selecting a origin vertex by click on canvas
    */
void HidroEditionWindow::addEdgeFromByClickRadioButton_clicked()
{
	releaseTools();

    _addEdgeVertexFrom = true;

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addEdgeFromIdentLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Add Edge From by Id.
    * Used to create a new edge and define a origin vertex by id on interface
    */
void HidroEditionWindow::addEdgeFromByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addEdgeFromIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Add Edge To by click.
    * Used to create a new edge and selecting a destiny vertex by click on canvas
    */
void HidroEditionWindow::addEdgeToByClickRadioButton_clicked()
{
	releaseTools();

	_addEdgeVertexTo = true;

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addEdgeToIdentLineEdit->setDisabled(true);
    
//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Add Edge From by Id.
    * Used to create a new edge and define a origin vertex by id on interface
    */
void HidroEditionWindow::addEdgeToByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	addEdgeToIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Add Edge Execute.
    * Used to add a new edge defined by user on interface
    */
void HidroEditionWindow::addEdgePushButton_clicked()
{
	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	if(addEdgeFromIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex From not defined."));
		return;
	}

	if(addEdgeToIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex To not defined."));
		return;
	}

	if(edgeNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Edge name is not defined."));
		return;
	}
	std::string edgeName = edgeNameLineEdit->text().latin1();

	/*if(addEdgeAttrTable->numRows() == 0)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Edge attributes is not defined."));
		return;
	}*/

//get attributes
	std::vector<std::string> attrs;
	for(int i = 0; i < addEdgeAttrTable->numRows(); ++i)
	{
		attrs.push_back(addEdgeAttrTable->text(i, 1).latin1());
	}

	TeTheme* vertexTheme = dynamic_cast<TeTheme*>(_vertexTheme->getTheme());
	TeTheme* edgetheme	 = dynamic_cast<TeTheme*>(_edgeTheme->getTheme());

//execute
	HidroEdgeEdition edition(edgetheme, vertexTheme, _parameters->teqtgrid_ptr_);
	if(!edition.addEdge(addEdgeFromIdentLineEdit->text().latin1(), 
						addEdgeToIdentLineEdit->text().latin1(),
						attrs, edgeName))
	{
		QMessageBox::warning(this, tr("Warning"), edition.getErrorMessage().c_str());
		return;
	}

	_parameters->plotTVData();

	QMessageBox::warning(this, tr("Warning"), tr("Edge added correctly."));
}

/** \brief HidroEditionWindow Change Edge Selection by Click.
    * Used to select a edge to be changed by click on canvas
    */
void HidroEditionWindow::edgeChangeSelectionByClickRadioButton_clicked()
{
	releaseTools();

	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	_changeEdge	= true;

	edgeChangeSelectionIdentLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Change Edge Selection by Id.
    * Used to select a edge to be changed by id on interface
    */
void HidroEditionWindow::edgeChangeSelectionByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	edgeChangeSelectionIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Change Edge Vertex Selection by Click.
    * Used to select vertex to be changed in selected edge by click on canvas
    */
void HidroEditionWindow::edgeChangeVertexByClickRadioButton_clicked()
{
	releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	_changeEdgeVertex = true;

	edgeChangeVertexIdentLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow Change Edge Vertex Selection by Id.
    * Used to select vertex to be changed in selected edge by Id on interface
    */
void HidroEditionWindow::edgeChangeVertexByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_vertexTheme);

	edgeChangeVertexIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Change Edge Execute.
    * Used to change an exist edge defined by user on interface
    */
void HidroEditionWindow::edgeChangePushButton_clicked()
{
	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	if(edgeChangeSelectionIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Edge not defined."));
		return;
	}

	if(edgeChangeVertexIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Vertex not defined."));
		return;
	}

	TeTheme* vertexTheme = dynamic_cast<TeTheme*>(_vertexTheme->getTheme());
	TeTheme* edgeTheme	 = dynamic_cast<TeTheme*>(_edgeTheme->getTheme());
	

//execute
	HidroEdgeEdition edition(edgeTheme, vertexTheme, _parameters->teqtgrid_ptr_);
	if(!edition.changeEdge( edgeChangeSelectionIdentLineEdit->text().latin1(),
							edgeChangeVertexIdentLineEdit->text().latin1(),
							edgeChangeVertexFromRadioButton->isChecked()))
	{
		QMessageBox::warning(this, tr("Warning"), edition.getErrorMessage().c_str());
		return;
	}

	_parameters->plotTVData();
	
	QMessageBox::warning(this, tr("Warning"), tr("Edge changed correctly."));
}

/** \brief HidroEditionWindow Remove Edge by Click.
    * Used to remove a edge selected edge by click on canvas
    */
void HidroEditionWindow::removeEdgeByClickRadioButton_clicked()
{
	releaseTools();

	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	_removeEdge	= true;

	removeEdgeIdentLineEdit->setDisabled(true);

//connect terraView clicked
	connect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));    
}

/** \brief HidroEditionWindow Remove Edge by Id.
    * Used to remove a edge selected edge by Id on interface
    */
void HidroEditionWindow::removeEdgeByIdentRadioButton_clicked()
{
    releaseTools();

	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	removeEdgeIdentLineEdit->setDisabled(false);
}

/** \brief HidroEditionWindow Remove Edge Execute.
    * Used to remove an exist edge defined by user on interface
    */
void HidroEditionWindow::removeEdgePushButton_clicked()
{
	_parameters->setCurrentThemeAppPtr(_edgeTheme);

	if(removeEdgeIdentLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Edge not defined."));
		return;
	}

	TeTheme* vertexTheme = dynamic_cast<TeTheme*>(_vertexTheme->getTheme());
	TeTheme* edgeTheme	 = dynamic_cast<TeTheme*>(_edgeTheme->getTheme());
	
//execute
	HidroEdgeEdition edition(edgeTheme, vertexTheme, _parameters->teqtgrid_ptr_);
	if(!edition.removeEdge(removeEdgeIdentLineEdit->text().latin1()))
	{
		QMessageBox::warning(this, tr("Warning"), edition.getErrorMessage().c_str());
		return;
	}

	_parameters->plotTVData();
	
	QMessageBox::warning(this, tr("Warning"), tr("Edge removed correctly."));
}

/** \brief HidroEditionWindow listGraphs function.
    * Used to list all graph names from current database
	* inside a combo box in interface.
    */
void HidroEditionWindow::listGraphs()
{
	graphNameComboBox->clear();

	HidroMetadata metadata(_parameters->getCurrentDatabasePtr());

	std::vector<std::string> graphList = metadata.getGraphNameListFromDB();

	graphNameComboBox->insertItem("");

	for(unsigned int i =0; i < graphList.size(); ++i)
	{
		graphNameComboBox->insertItem(graphList[i].c_str());
	}
}

/** \brief HidroEditionWindow listThemes function.
    * Used to list all themes belongs to selected graph 
	* inside a combo box in interface.
    */
void HidroEditionWindow::listThemes()
{
	HidroUtils utils(_parameters->getCurrentDatabasePtr());

	std::vector<std::string> vertexThemes = utils.listLayerThemes(vertexLayerLineEdit->text().latin1());
	hidroVertexThemeComboBox->clear();
	hidroVertexThemeComboBox->insertItem("");

	for(unsigned int i =0; i < vertexThemes.size(); ++i)
	{
		hidroVertexThemeComboBox->insertItem(vertexThemes[i].c_str());
	}
	
	std::vector<std::string> edgesThemes = utils.listLayerThemes(edgeLayerLineEdit->text().latin1());
	hidroEdgeThemeComboBox->clear();
	hidroEdgeThemeComboBox->insertItem("");

	for(unsigned int i =0; i < edgesThemes.size(); ++i)
	{
		hidroEdgeThemeComboBox->insertItem(edgesThemes[i].c_str());
	}
}

/** \brief HidroEditionWindow getMouseClicked function.
    * Function used to get the mouse clicked over the canvas.
	* This signal is emit from application, so we have to connect this
	* signal with this function.
	* \param coord		Input parameter, used to define the geo coord from click (this coord is in canvas projection)
	* \param state		Input parameter, used to indicate the mouse button state
	* \param point		Input parameter, used to define the canvas coord from click
    */
void HidroEditionWindow::getMouseClicked( TeCoord2D & coord, int /*state*/, QPoint & /*point*/ )
{
	HidroUtils utils(_parameters->getCurrentDatabasePtr());
	
	std::string graphName		= graphNameComboBox->currentText().latin1();
	TeTheme* currentTheme		= (TeTheme*)_parameters->getCurrentThemeAppPtr()->getTheme();
	TeProjection* projCanvas	= _parameters->teqtcanvas_ptr_->projection();
	double pixelSize			= _parameters->teqtcanvas_ptr_->pixelSize();

	if(_addVertex)
	{
		std::string xCoordStr = Te2String(coord.x(), 6);
		addVertexXCoordLineEdit->setText(xCoordStr.c_str());

		std::string yCoordStr = Te2String(coord.y(), 6);
		addVertexYCoordLineEdit->setText(yCoordStr.c_str());
	}
	else if(_removeVertex)
	{
		std::string value = utils.getPointName(graphName, currentTheme, projCanvas, pixelSize, coord);
		removeVertexIdentLineEdit->setText(value.c_str());
	}
	else if(_addEdgeVertexFrom)
	{
		std::string value = utils.getPointName(graphName, currentTheme, projCanvas, pixelSize, coord);
		addEdgeFromIdentLineEdit->setText(value.c_str());
	}
	else if(_addEdgeVertexTo)
	{
		std::string value = utils.getPointName(graphName, currentTheme, projCanvas, pixelSize, coord);
		addEdgeToIdentLineEdit->setText(value.c_str());
	}
	else if(_changeEdge)
	{
		std::string value = utils.getLineName(graphName, currentTheme, projCanvas, pixelSize, coord);
		edgeChangeSelectionIdentLineEdit->setText(value.c_str());
	}
	else if(_changeEdgeVertex)
	{
		std::string value = utils.getPointName(graphName, currentTheme, projCanvas, pixelSize, coord);
		edgeChangeVertexIdentLineEdit->setText(value.c_str());
	}
	else if(_removeEdge)
	{
		std::string value = utils.getLineName(graphName, currentTheme, projCanvas, pixelSize, coord);
		removeEdgeIdentLineEdit->setText(value.c_str());
	}

	releaseTools();
}


/** \brief HidroEditionWindow release tools function.
    * Used to disable all tools in interface
    */
void HidroEditionWindow::releaseTools()
{
	_addVertex				= false;
    _removeVertex			= false;
    _addEdgeVertexFrom		= false;
    _addEdgeVertexTo		= false;
    _changeEdge				= false;
	_changeEdgeVertex		= false;
    _removeEdge				= false;

	disconnect(_parameters->teqtcanvas_ptr_, SIGNAL(mousePressed(TeCoord2D&, int, QPoint&)), this, SLOT(getMouseClicked(TeCoord2D&, int, QPoint&)));
}

/** \brief HidroEditionWindow enter attr vertex function.
    * Used to list all vertex attributes in table, to save a new vertex
	* its necessary define the attributes for this new object, if these
	* attributes dont be defined correctly some algorithms over the graph
	* can not be executed correctly.
    */
void HidroEditionWindow::enterAttrVertexPushButton_clicked()
{
	HidroMetadata metadata(_parameters->getCurrentDatabasePtr());

	std::vector<std::string> attr = metadata.getLayerPointsAttributes(graphNameComboBox->currentText().latin1(), false);

	addVertexAttrTable->setNumCols(2);
	addVertexAttrTable->setNumRows(attr.size());

	for(unsigned int i = 0; i < attr.size(); ++i)
	{
		addVertexAttrTable->setText(i, 0, attr[i].c_str());
		addVertexAttrTable->setText(i, 1, "");
	}

	QStringList list;
	list.append("Attribute");
	list.append("Value");

	addVertexAttrTable->setColumnLabels(list);

	addVertexAttrTable->setColumnReadOnly(0, true);
	addVertexAttrTable->setColumnReadOnly(1, false);

	addVertexAttrTable->adjustColumn(0);
	addVertexAttrTable->adjustColumn(1);
}

/** \brief HidroEditionWindow enter attr edge function.
    * Used to list all edges attributes in table, to save a new edge
	* its necessary define the attributes for this new object, if these
	* attributes dont be defined correctly some algorithms over the graph
	* can not be executed correctly.
    */
void HidroEditionWindow::enterAttrEdgePushButton_clicked()
{
	HidroMetadata metadata(_parameters->getCurrentDatabasePtr());

	std::vector<std::string> attr = metadata.getLayerLinesAttributes(graphNameComboBox->currentText().latin1(), false);

	addEdgeAttrTable->setNumCols(2);
	addEdgeAttrTable->setNumRows(attr.size());

	for(unsigned int i = 0; i < attr.size(); ++i)
	{
		addEdgeAttrTable->setText(i, 0, attr[i].c_str());
		addEdgeAttrTable->setText(i, 1, "");
	}

	QStringList list;
	list.append("Attribute");
	list.append("Value");

	addEdgeAttrTable->setColumnLabels(list);

	addEdgeAttrTable->setColumnReadOnly(0, true);
	addEdgeAttrTable->setColumnReadOnly(1, false);

	addEdgeAttrTable->adjustColumn(0);
	addEdgeAttrTable->adjustColumn(1);
	
}



void HidroEditionWindow::hidroVertexThemeComboBox_activated( const QString & value )
{
	_vertexTheme = NULL;

	if(!value.isEmpty())
	{
		TeQtViewItem* viewItem = _parameters->teqtviewslistview_ptr_->currentViewItem();

		std::vector<TeQtThemeItem*> themeItemVec = viewItem->getThemeItemVec();
		
		if (themeItemVec.size() != 0)
		{
			for (unsigned int i = 0; i < themeItemVec.size(); ++i)
			{
				TeAppTheme* appTheme = themeItemVec[i]->getAppTheme();
				if (((TeTheme*)appTheme->getTheme())->name() == value.latin1())
				{
					_vertexTheme = appTheme;
					break;
				}
			}
		}	
	}

	if(_vertexTheme && _edgeTheme)
	{
		editTabWidget->setDisabled(false);
	}
	else
	{
		editTabWidget->setDisabled(true);
	}
}


void HidroEditionWindow::hidroEdgeThemeComboBox_activated( const QString & value )
{
	_edgeTheme = NULL;

	if(!value.isEmpty())
	{
		TeQtViewItem* viewItem = _parameters->teqtviewslistview_ptr_->currentViewItem();

		std::vector<TeQtThemeItem*> themeItemVec = viewItem->getThemeItemVec();
		
		if (themeItemVec.size() != 0)
		{
			for (unsigned int i = 0; i < themeItemVec.size(); ++i)
			{
				TeAppTheme* appTheme = themeItemVec[i]->getAppTheme();
				if (((TeTheme*)appTheme->getTheme())->name() == value.latin1())
				{
					_edgeTheme = appTheme;
					break;
				}
			}
		}	
	}

	if(_vertexTheme && _edgeTheme)
	{
		editTabWidget->setDisabled(false);
	}
	else
	{
		editTabWidget->setDisabled(true);
	}
}


void HidroEditionWindow::openOptEdPushButton_clicked()
{
	if(baseNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Base name not defined."));
		return;
	}

    if(!_optEdWindow)
	{
		delete _optEdWindow;
	}

	_optEdWindow = new HidroOptimizedEditionWindow(this, "Optimized Edition", false);

	_optEdWindow->init(_parameters);

	_optEdWindow->setGraphName(graphNameComboBox->currentText().latin1());
	_optEdWindow->setBaseName(baseNameLineEdit->text().latin1());
	_optEdWindow->setVertexTheme(_vertexTheme);
	_optEdWindow->setEdgeTheme(_edgeTheme);
	_optEdWindow->createAutoAttributes(autoAttrCheckBox->isChecked());

	_optEdWindow->show();
}

/*
** ----------------------------------------------------------------------------
** End:
*/