/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroFlowPath.h>

#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <HidroPersister.h>
#include <HidroBatchPointsWindow.h>

#include <qsettings.h>
#include <qcombobox.h>


bool HidroFlowPathWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  flowGridComboBox->clear();
  flowGridComboBox->insertItem("");  

  
  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{		
    flowGridComboBox->insertItem(layerNames[i].c_str());   
  }

  batchPointsComboBox->clear();
  batchPointsComboBox->insertItem("");

  std::vector<std::string> pointLayerNames = utils.listLayers( false, false, true );
  
  for(unsigned int i = 0; i < pointLayerNames.size(); ++i)
	{
		batchPointsComboBox->insertItem(pointLayerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastLDD = settings.readEntry("lastLDD");
  QString lastPoints = settings.readEntry("lastPoints");    
   
  int index;  

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  index = comboboxFind( batchPointsComboBox, lastPoints );
  batchPointsComboBox->setCurrentItem( index );
  
  return true;
}


void HidroFlowPathWindow::runPushButton_clicked()
{
  // check inputs

  // Get View
  TeView* view = 0;
  view = parameters_->getCurrentViewPtr();
  if( !view )
  {
    QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
    return;
  }
  
  // LDD
	if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input flow grid layer not defined."));
		return;
	}

  //Points
  if(batchPointsComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Batch Points Layer is not defined."));
		return;
	}
  
  HidroUtils utils(parameters_->getCurrentDatabasePtr());
  std::string errorMessage = "";

  // Output name (base layer  name)
	if(pathsLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output DEM name not defined."));
		return;
	}
  if(!utils.checkLayerName(pathsLineEdit->text().latin1(), errorMessage))
	{
		QMessageBox::warning(this, tr("Warning"), errorMessage.c_str());
		return;
	}  

  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();

  // pega os BatchPoints
  TeLayer* batchPointLayer = NULL;
	batchPointLayer = utils.getLayerByName(batchPointsComboBox->currentText().latin1());
	if(!batchPointLayer)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Error getting Batch Points layer from database."));
		return;
	}
  TePointSet pointSet;
  if( !batchPointLayer->getPoints( pointSet ) )
  {
    QMessageBox::warning(this, tr("Warning"), tr("The layer dont have any points!"));    
		return;
  }

  std::string outputName = pathsLineEdit->text().latin1();

  // Flow Path
  HidroFlowPath flowPath(
    lddRaster,
    pointSet,
    outputName,
    parameters_->getCurrentDatabasePtr());

  // execut the algorithm
  if( !flowPath.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(flowPath.getErrorMessage().c_str()));    
    
    return;
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastLDD", flowGridComboBox->currentText() );
  settings.writeEntry( "lastPoints", batchPointsComboBox->currentText() );

  // create theme
  TeLayer* vectorLayer = NULL;
	vectorLayer = utils.getLayerByName( pathsLineEdit->text().latin1() );
  if( view )
  {
    HidroPersister persister(parameters_->getCurrentDatabasePtr());
    persister.createTheme( pathsLineEdit->text().latin1(), "", view, vectorLayer );    
  } 

  // update the TerraView interface
	parameters_->updateTVInterface();

  // close the window
  //accept(); 

  // informe the successful process
  QString message;
  message.append("Flow Paths\n");
  message.append("Start Time: ");
  message.append( flowPath.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( flowPath.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( flowPath.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );
}


void HidroFlowPathWindow::batchPointsToolButton_clicked()
{
  close();
  
  HidroBatchPointsWindow* batchPointsWindow = new HidroBatchPointsWindow((QWidget*)this, "Batch Points Window", false);  
	batchPointsWindow->init2(parameters_, false);
	batchPointsWindow->show();  
 
}
