/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroHydrologicalVariables.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <TeDatabase.h>

#include <qstring.h>
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qspinbox.h>

#include <string>

bool HidroHydrologicalVariablesWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  lddGridComboBox->clear();
  lddGridComboBox->insertItem("");
  demGridComboBox->clear();
  demGridComboBox->insertItem("");
  drainGridComboBox->clear();
  drainGridComboBox->insertItem("");

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
  {
		lddGridComboBox->insertItem(layerNames[i].c_str());		
		demGridComboBox->insertItem(layerNames[i].c_str());		
		drainGridComboBox->insertItem(layerNames[i].c_str());		
  }
  contrAreaComboBox->clear();
  contrAreaComboBox->insertItem("( m^2 )");
  contrAreaComboBox->insertItem("( Km^2 )");
  contrAreaComboBox->insertItem("( pixels )");
  maxOrderComboBox->clear();
  maxOrderComboBox->insertItem("Strahler");
  maxOrderComboBox->insertItem("Shreve");
  handComboBox->clear();
  handComboBox->insertItem("Maximum Strahler Order");
  handComboBox->insertItem("Maximum Shreve Order");
  handComboBox->insertItem("Grid Drainage");
  for(unsigned int i = 0; i < 6; ++i)
  {
	 flagVariables[i] = false;
  }
  demGridComboBox->setEnabled(false);
  drainGridComboBox->setEnabled(false);
//  runPushButton->hide();
//  runPushButton->setEnabled(false);
  return true;
}

void HidroHydrologicalVariablesWindow::runPushButton_clicked()
{
  // Selected Variables
/*  bool flagVariables[6];
  flagVariables[0] = contrAreaCheckBox->isChecked();
  flagVariables[1] = diffTopCheckBox->isChecked();
  flagVariables[2] = diffFlowCheckBox->isChecked();
  flagVariables[3] = slopeFlowCheckBox->isChecked();
  flagVariables[4] = maxOrderCheckBox->isChecked();
  flagVariables[5] = handCheckBox->isChecked();
*/
  unsigned int options[6];
  options[0] = contrAreaComboBox->currentItem(); //unit: m2, km2 or pixel
  options[1] = diffFlowSpinBox->value(); //number of neighbours of diff
  options[2] = slopeFlowSpinBox->value(); //number of neighbours of slope
  options[3] = maxOrderComboBox->currentItem(); //Strahler or Shreve
  options[4] = handComboBox->currentItem(); //Strahler, Shreve or Drainage Grid
  options[5] = handSpinBox->value(); //Order

  std::string suffix[6];
  suffix[0] = "_ContrArea";
  suffix[1] = "_DiffTop";
  suffix[2] = "_DiffFlow"+TeAgnostic::to_string(options[1]);
  suffix[3] = "_SlopeFlow"+TeAgnostic::to_string(options[2]);
  suffix[4] = "_MaxOrder";
  if(options[3] == 0)
  {
	suffix[4] += "Strahler";
  }
  else
  {
	suffix[4] += "Shreve";
  }
  suffix[5] = "_Hand";
  if(options[4] == 0)
  {
	suffix[5] += "Strahler"+TeAgnostic::to_string(options[5]);
  }
  else if(options[4] == 1)
  {
	suffix[5] += "Shreve"+TeAgnostic::to_string(options[5]);
  }
  else
  {
	suffix[5] += "DrainageGrid";
  }

  bool varflag = false;
  unsigned int i = 0;
  while ((!varflag) && (i<6))
  {
	  varflag = flagVariables[i];
	  i++;
  }
  if(!varflag)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Please select at least one morphometric variable."));
		return;
  }

  // Check inputs
  //LDD
  if(lddGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input LDD Grid not defined."));
		return;
	}
  // DEM
  bool demflag = flagVariables[1] || flagVariables[2] || flagVariables[3] || flagVariables[5];
  if(demGridComboBox->currentText().isEmpty() && demflag)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM Grid not defined."));
		return;
	}
  bool drainflag = flagVariables[5] && (options[4] == 2);
  if(drainGridComboBox->currentText().isEmpty() && drainflag)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Drainage Grid not defined."));
		return;
	}

  // Output File
  if(gridNameLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output File not defined."));
		return;
  }

  // Parameters
  std::string lddGridName = lddGridComboBox->currentText().latin1();
  std::string demGridName = demGridComboBox->currentText().latin1();
  std::string drainGridName = drainGridComboBox->currentText().latin1();
  std::string outGridName = gridNameLineEdit->text().latin1();

  // open input raster's
  TeDatabase* database = parameters_->getCurrentDatabasePtr();
  HidroUtils utils( database );

  TeView* view = NULL;
  if(ViewCheckBox->isChecked())
  {
    // Get View
    view = parameters_->getCurrentViewPtr();
    if( !view )
    {
      QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
      return;
    }
  }

  // LDD
  TeLayer* lddLayer = NULL;
	lddLayer = utils.getLayerByName( lddGridName );
  TeRaster* lddRaster = NULL;
  lddRaster = lddLayer->raster();

  // DEM
  TeLayer* demLayer = NULL;
  TeRaster* demRaster = NULL;
  if(demflag)
  {
	demLayer = utils.getLayerByName( demGridName );
    demRaster = demLayer->raster();
  }

  // DRAINAGE
  TeLayer* drainLayer = NULL;
  TeRaster* drainRaster = NULL;
  if(drainflag)
  {
	drainLayer = utils.getLayerByName( drainGridName );
    drainRaster = drainLayer->raster();
  }

  // output raster
  TeRaster* rasterpoint[6];
  for( unsigned int i=0; i<6; i++ )
  {
    rasterpoint[i] = NULL;
  }

  // Hydrological Variable
  HidroHydrologicalVariables hydrologicalVariables( lddRaster, demRaster, drainRaster, rasterpoint, flagVariables, options);

  // execute the algorithm
  if( !hydrologicalVariables.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(hydrologicalVariables.getErrorMessage().c_str()));    
    return;
  }

  // import result to database and save theme to current view
  TeProgress::instance()->reset();
  TeProgress::instance()->setMessage("Saving Hydrological Variables into database.");
  std::string layername;
  for( unsigned int i=0; i<6; i++ )
  {
    if( rasterpoint[i] != NULL)
	{
		layername = database->getNewLayerName( outGridName+suffix[i] );
		if( view )
		{
			utils.saveOutputRasterCreatingTheme( layername, rasterpoint[i], view);
//			TeTheme* theme = utils.getThemeByName( layername );
//			theme->visibility(1);
		}
		else
		{
			utils.saveOutputRaster( layername, rasterpoint[i] );
		}
	}
  }

  // update the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Hydrological Variables\n");
  message.append("Start Time: ");
  message.append( hydrologicalVariables.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( hydrologicalVariables.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( hydrologicalVariables.getTimeTotal().c_str() );

  QMessageBox::information(this, tr("Information"), tr(message) );  

  // close the window
  accept();

}

void HidroHydrologicalVariablesWindow::contrAreaCheckBox_clicked()
{
  flagVariables[0] = contrAreaCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::diffTopCheckBox_clicked()
{
  flagVariables[1] = diffTopCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::diffFlowCheckBox_clicked()
{
  flagVariables[2] = diffFlowCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::slopeFlowCheckBox_clicked()
{
  flagVariables[3] = slopeFlowCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::maxOrderCheckBox_clicked()
{
  flagVariables[4] = maxOrderCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::handCheckBox_clicked()
{
  flagVariables[5] = handCheckBox->isChecked();
  updateWindow();
}

void HidroHydrologicalVariablesWindow::handComboBox_activated(int index)
{
  if(index == 2)
  {
	drainGridComboBox->setEnabled(true);
	handSpinBox->hide();
  }
  else
  {
	drainGridComboBox->setEnabled(false);
	handSpinBox->show();
  }
  updateWindow();
}

void HidroHydrologicalVariablesWindow::updateWindow()
{
  bool demflag = flagVariables[1] || flagVariables[2] || flagVariables[3] || flagVariables[5];
  demGridComboBox->setEnabled(demflag);
  drainGridComboBox->setEnabled(flagVariables[5] && (handComboBox->currentItem() == 2));
}
