/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroTopographicIndexMDInfinite.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>

#include <qstring.h>
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>

#include <string>

void HidroTopographicIndexWindow::okPushButton_clicked()
{
  // Check inputs  

  // DEM
  if(demComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input DEM layer not defined."));
		return;
	}

  // LDD
  if(flowGridComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input Flow Grid layer not defined."));
		return;
	}
  
  // highSubwatershed
  if(highSubwatershedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input high Subwatershed layer not defined."));
		return;
	}

  // lowSubwatershed
  if(lowSubwatershedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input low Subwatershed layer not defined."));
		return;
	}

   // lowAccumulated
  if(lowAccumulatedComboBox->currentText().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Input low Accumulated layer not defined."));
		return;
	}

  // Model Resolution
  if(factorLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Model Resolution not defined."));
		return;
  }

  // CIT
  if(citLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("CIT not defined."));
		return;
  }

  // NAC
  if(nacLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("NAC not defined."));
		return;
  }

  // Cells File
  if(cellsFileLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Cells File not defined."));
		return;
  }

  // Output File
  if(outputFileLineEdit->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Warning"), tr("Output File not defined."));
		return;
  }

  // open input raster's
  HidroUtils utils(parameters_->getCurrentDatabasePtr());  
  
  // DEM
  TeLayer* demLayer = NULL;
	demLayer = utils.getLayerByName( demComboBox->currentText().latin1() );
  TeRaster* demRaster = NULL;
  demRaster = demLayer->raster();

  // DEM
  TeLayer* flowGridLayer = NULL;
	flowGridLayer = utils.getLayerByName( flowGridComboBox->currentText().latin1() );
  TeRaster* flowGridRaster = NULL;
  flowGridRaster = flowGridLayer->raster();

  // high Subwatershed
  TeLayer* highSubwatershedLayer = NULL;
	highSubwatershedLayer = utils.getLayerByName( highSubwatershedComboBox->currentText().latin1() );
  TeRaster* highSubwatershedRaster = NULL;
  highSubwatershedRaster = highSubwatershedLayer->raster();

  // low Subwatershed
  TeLayer* lowSubwatershedLayer = NULL;
	lowSubwatershedLayer = utils.getLayerByName( lowSubwatershedComboBox->currentText().latin1() );
  TeRaster* lowSubwatershedRaster = NULL;
  lowSubwatershedRaster = lowSubwatershedLayer->raster();

  // low Accumulated
  TeLayer* lowAccumulatedLayer = NULL;
	lowAccumulatedLayer = utils.getLayerByName( lowAccumulatedComboBox->currentText().latin1() );
  TeRaster* lowAccumulatedRaster = NULL;
  lowAccumulatedRaster = lowAccumulatedLayer->raster();

  // Parameters
  int factor = factorLineEdit->text().toFloat();
  float cit = citLineEdit->text().toFloat();
  int nac = nacLineEdit->text().toInt();
  std::string cellFileName = cellsFileLineEdit->text().latin1();
  std::string outFileName = outputFileLineEdit->text().latin1();

  // Topographic Index
  HidroTopographicIndexMDInfinite topographicIndexMDInfinite( demRaster,
    flowGridRaster,
    highSubwatershedRaster,
    lowSubwatershedRaster,
    lowAccumulatedRaster,
    cellFileName,
    outFileName,
    factor,
    cit,
    nac );

  // execut the algorithm
  if( !topographicIndexMDInfinite.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(topographicIndexMDInfinite.getErrorMessage().c_str()));
    
    if( demRaster )
    {
      delete demRaster;
    }

    if( flowGridRaster )
    {
      delete flowGridRaster;
    }

    if( highSubwatershedRaster )
    {
      delete highSubwatershedRaster;
    }

    if( lowSubwatershedRaster )
    {
      delete lowSubwatershedRaster;
    }

    if( lowAccumulatedRaster )
    {
      delete lowAccumulatedRaster;
    }
  }

  // update settings
  QSettings settings;  
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  
  settings.writeEntry( "lastDEM", demComboBox->currentText() );
  settings.writeEntry( "lastLDD", flowGridComboBox->currentText() );
  settings.writeEntry( "lastSUB", highSubwatershedComboBox->currentText() );
  settings.writeEntry( "lastUpSUB", lowSubwatershedComboBox->currentText() );
  settings.writeEntry( "lastUpACU", lowAccumulatedComboBox->currentText() );
  settings.writeEntry( "lastFactor", factorLineEdit->text() );
  settings.writeEntry( "lastCIT", citLineEdit->text() );
  settings.writeEntry( "lastNAC", nacLineEdit->text() );
  settings.writeEntry( "lastPARTOP", outputFileLineEdit->text() );
  settings.writeEntry( "lastCELLHIG", cellsFileLineEdit->text() );

  // lsdate the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Topographic Index\n");
  message.append("Start Time: ");
  message.append( topographicIndexMDInfinite.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( topographicIndexMDInfinite.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( topographicIndexMDInfinite.getTimeTotal().c_str() );

	QMessageBox::information(this, tr("Information"), tr(message) );

  // close the window
  accept(); 
}


void HidroTopographicIndexWindow::outputFileToolButton_clicked()
{
  QSettings settings;
  settings.setPath( "TerraHidro.br", "Topographic Index", QSettings::User );

  QString outPath = settings.readEntry( "outFile" );  

  QString outFileName = QFileDialog::getSaveFileName(outPath,
    "HIG Files(*.hig *.HIG);;TXT Files(*.txt *.TXT);;ALL Files(*.*)",this,"Save as","File name");
	
  if (!outFileName.isEmpty())	
  {
	  outputFileLineEdit->setText(outFileName);
    QFileInfo outFile( outFileName );
    outPath = outFile.dirPath();
    settings.writeEntry( "outFile", outPath );
  }
}

bool HidroTopographicIndexWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  demComboBox->clear();
	demComboBox->insertItem("");

  flowGridComboBox->clear();
	flowGridComboBox->insertItem("");

	highSubwatershedComboBox->clear();
	highSubwatershedComboBox->insertItem("");

  lowSubwatershedComboBox->clear();
	lowSubwatershedComboBox->insertItem("");

  lowAccumulatedComboBox->clear();
	lowAccumulatedComboBox->insertItem("");

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
	std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
	{
		demComboBox->insertItem(layerNames[i].c_str());
    flowGridComboBox->insertItem(layerNames[i].c_str());
		highSubwatershedComboBox->insertItem(layerNames[i].c_str());
    lowSubwatershedComboBox->insertItem(layerNames[i].c_str());
    lowAccumulatedComboBox->insertItem(layerNames[i].c_str());
  }

  // qsettings defaults
  QSettings settings;

  // LDD
  settings.setPath( "TerraHidro.br", "LDD", QSettings::User );  

  QString lastDEM = settings.readEntry("lastDEM");
  QString lastLDD = settings.readEntry("lastLDD");
  QString lastSUB = settings.readEntry("lastSUB");
  QString lastUpSUB = settings.readEntry("lastUpSUB");
  QString lastUpACU = settings.readEntry("lastUpACU");
  QString lastFactor = settings.readEntry("lastFactor");
  QString lastCIT = settings.readEntry("lastCIT");
  QString lastNAC = settings.readEntry("lastNAC");
  QString lastPARTOP = settings.readEntry("lastPARTOP");
  QString lastCELLHIG = settings.readEntry("lastCELLHIG");

  int index;

  index = comboboxFind( demComboBox, lastDEM );
  demComboBox->setCurrentItem( index );

  index = comboboxFind( flowGridComboBox, lastLDD );
  flowGridComboBox->setCurrentItem( index );

  index = comboboxFind( highSubwatershedComboBox, lastSUB );
  highSubwatershedComboBox->setCurrentItem( index );

  index = comboboxFind( lowSubwatershedComboBox, lastUpSUB );
  lowSubwatershedComboBox->setCurrentItem( index );
  
  index = comboboxFind( lowAccumulatedComboBox, lastUpACU );
  lowAccumulatedComboBox->setCurrentItem( index );

  factorLineEdit->setText( lastFactor );
  citLineEdit->setText( lastCIT );
  nacLineEdit->setText( lastNAC );
  outputFileLineEdit->setText( lastPARTOP );  
  cellsFileLineEdit->setText( lastCELLHIG );  

  return true;
}


void HidroTopographicIndexWindow::destroy()
{
}


void HidroTopographicIndexWindow::cellsFileToolButton_clicked()
{
  QSettings settings;
  settings.setPath( "TerraHidro.br", "Topographic Index", QSettings::User );

  QString path = settings.readEntry( "cellsFile" );  

  QString cellsFileName = QFileDialog::getOpenFileName(path, 
		"HIG Files(*.hig *.HIG);;TXT Files(*.txt *.TXT);;ALL Files(*.*)",
	  this, 0, tr( "Open Cells File"));
	
	if (!cellsFileName.isEmpty())
  {
		cellsFileLineEdit->setText(cellsFileName);
    QFileInfo cellsFile( cellsFileName );
    path = cellsFile.dirPath();
    settings.writeEntry( "cellsFile", path );
  }
}
