/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <HidroTreeClassify.h>
#include <HidroUtils.h>
#include <HidroFlowUtils.h>
#include <TeDatabase.h>

#include <qstring.h>
#include <qfiledialog.h>
#include <qsettings.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qspinbox.h>

#include <string>
#include <regex>


bool HidroTreeClassifyWindow::init( PluginParameters * parameters )
{
  if( parameters == NULL )
  {
    return false;
  }

  if( !parameters->getCurrentDatabasePtr() )
	{
		return false;
	}

  parameters_ = parameters;

  // clear all layers names inside the combo box
  slopeGridComboBox->clear();
  slopeGridComboBox->insertItem("");
  minCurvGridComboBox->clear();
  minCurvGridComboBox->insertItem("");
  horCurvGridComboBox->clear();
  horCurvGridComboBox->insertItem("");
  contrAreaGridComboBox->clear();
  contrAreaGridComboBox->insertItem("");
  diff16GridComboBox->clear();
  diff16GridComboBox->insertItem("");
  diff64GridComboBox->clear();
  diff64GridComboBox->insertItem("");
  handGridComboBox->clear();
  handGridComboBox->insertItem("");
  lddGridComboBox->clear();
  lddGridComboBox->insertItem("");

  // fill it with raster layers
  HidroUtils utils( parameters->getCurrentDatabasePtr() );
  std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
  {
		slopeGridComboBox->insertItem(layerNames[i].c_str());		
		minCurvGridComboBox->insertItem(layerNames[i].c_str());		
		horCurvGridComboBox->insertItem(layerNames[i].c_str());		
		contrAreaGridComboBox->insertItem(layerNames[i].c_str());		
		diff16GridComboBox->insertItem(layerNames[i].c_str());		
		diff64GridComboBox->insertItem(layerNames[i].c_str());		
		handGridComboBox->insertItem(layerNames[i].c_str());		
		lddGridComboBox->insertItem(layerNames[i].c_str());		
  }
  slopeGridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_Slope")+1));
  minCurvGridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_MinCurv")+1));
  horCurvGridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_HorCurv")+1));
  contrAreaGridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_ContrArea")+1));
  diff16GridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_DiffFlow16")+1));
  diff64GridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_DiffFlow64")+1));
  handGridComboBox->setCurrentItem((unsigned int) (findfirstlayer( "_HandStrahler5")+1));
  lddGridComboBox->setEnabled(false);
  classComboBox->clear();
  classComboBox->insertItem("Drainage / Non Drainage");
  classComboBox->insertItem("Spring / Drainage / Non Drainage");
  classComboBox->insertItem("Each Leaf");
  sizeGapsSpinBox->setEnabled(false);
  sizeSegmentsSpinBox->setEnabled(false);
  orderComboBox->clear();
  orderComboBox->insertItem("Strahler");
  orderComboBox->insertItem("Shreve");
  orderComboBox->insertItem("None");
  orderComboBox->setEnabled(false);
  return true;
}

void HidroTreeClassifyWindow::runPushButton_clicked()
{
  // Check inputs
  // DEM
  bool noinput = slopeGridComboBox->currentText().isEmpty();
  noinput = noinput || minCurvGridComboBox->currentText().isEmpty();
  noinput = noinput || horCurvGridComboBox->currentText().isEmpty();
  noinput = noinput || contrAreaGridComboBox->currentText().isEmpty();
  noinput = noinput || diff16GridComboBox->currentText().isEmpty();
  noinput = noinput || diff64GridComboBox->currentText().isEmpty();
  noinput = noinput || handGridComboBox->currentText().isEmpty();
  if(noinput)
	{
		QMessageBox::warning(this, tr("Warning"), tr("Some Input Grid are not defined."));
		return;
	}

  bool lddflag = correctCheckBox->isChecked();
  if(lddGridComboBox->currentText().isEmpty() && lddflag)
  {
	QMessageBox::warning(this, tr("Warning"), tr("Input LDD Grid not defined."));
	return;
  }

  // Output File
  if(gridNameLineEdit->text().isEmpty())
  {
	QMessageBox::warning(this, tr("Warning"), tr("Output Grid not defined."));
	return;
  }
  // Parameters
  std::string lddGridName = lddGridComboBox->currentText().latin1();
  std::string tmpGridName;
  std::string outGridName = gridNameLineEdit->text().latin1();

  // open input raster's
  TeDatabase* database = parameters_->getCurrentDatabasePtr();
  HidroUtils utils( database );

  TeView* view = NULL;
  if(ViewCheckBox->isChecked())
  {
    // Get View
    view = parameters_->getCurrentViewPtr();
    if( !view )
    {
      QMessageBox::warning(this, tr("Warning"), tr("Please select one view in TerraView interface."));
      return;
    }
  }

  // Input Rasters
  TeLayer* tmpLayer = NULL;
  TeRaster* Raster[7];
  tmpGridName = slopeGridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[0] = tmpLayer->raster();
  tmpGridName = minCurvGridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[1] = tmpLayer->raster();
  tmpGridName = horCurvGridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[2] = tmpLayer->raster();
  tmpGridName = contrAreaGridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[3] = tmpLayer->raster();
  tmpGridName = diff16GridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[4] = tmpLayer->raster();
  tmpGridName = diff64GridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[5] = tmpLayer->raster();
  tmpGridName = handGridComboBox->currentText().latin1();
  tmpLayer = utils.getLayerByName( tmpGridName );
  Raster[6] = tmpLayer->raster();

  // LDD
  TeLayer* lddLayer = NULL;
  TeRaster* lddRaster = NULL;
  if(lddflag)
  {
	lddLayer = utils.getLayerByName( lddGridName );
    lddRaster = lddLayer->raster();
  }
  else
  {
	lddRaster = Raster[0];
  }

  unsigned int options[5];
  options[0] = classComboBox->currentItem(); //2 classes, 3 classes, each leaf
  options[1] = (options[0] == 0)?correctCheckBox->isChecked():0; //correct check
  options[2] = (options[1])?sizeGapsSpinBox->value():0; //size Gap to connect
  options[3] = (options[1])?sizeSegmentsSpinBox->value():0; //size Segments to eliminate
  options[4] = (options[1])?orderComboBox->currentItem():0; //None, Strahler or Shreve

  // Drain raster
  TeRaster* drainRaster = NULL;

  // Hydrological Variable
  HidroTreeClassify treeClassify( Raster, lddRaster, drainRaster, options);

  // execute the algorithm
  if( !treeClassify.execute() )
  {
    QMessageBox::warning(this, tr("Warning"), tr(treeClassify.getErrorMessage().c_str()));    
    return;
  }

  // import result to database and save theme to current view
  TeProgress::instance()->reset();
  TeProgress::instance()->setMessage("Saving Drainage Grid into database.");
  std::string layername;
  layername = database->getNewLayerName( outGridName );
  if( view )
	{
	  utils.saveOutputRasterCreatingTheme( layername, drainRaster, view);
	}
	else
	{
		utils.saveOutputRaster( layername, drainRaster );
	}

  // update the TerraView interface
  parameters_->updateTVInterface();

  // informe the successful process
  QString message;
  message.append("Tree Classify\n");
  message.append("Start Time: ");
  message.append( treeClassify.getTimeStart().c_str() );
  message.append("\nEnd Time: ");
  message.append( treeClassify.getTimeEnd().c_str() );
  message.append("\n\nTotal Time: ");
  message.append( treeClassify.getTimeTotal().c_str() );

  QMessageBox::information(this, tr("Information"), tr(message) );  

  // close the window
  accept();

}

int HidroTreeClassifyWindow::findfirstlayer( std::string str)
{
  int k = -1;
  HidroUtils utils( parameters_->getCurrentDatabasePtr() );
  std::vector<std::string> layerNames = utils.listLayers( true, false );
  for(unsigned int i = 0; i < layerNames.size(); ++i)
  {
	std::string strfull = layerNames[i];
	unsigned int pos = (strfull.size() > str.size())?strfull.size()-str.size():0;
	if(strfull.substr(pos,str.size()) == str)
	{
	  k = i;
	  break;
	}
 }
  return k;
}

void HidroTreeClassifyWindow::classComboBox_activated(int index)
{
  if(index == 0)
  {
    correctCheckBox->setEnabled(true);
    correctCheckBox_clicked();
  }
  else
  {
    correctCheckBox->setEnabled(false);
    sizeGapsSpinBox->setEnabled(false);
    sizeSegmentsSpinBox->setEnabled(false);
    orderComboBox->setEnabled(false);
  }
}

void HidroTreeClassifyWindow::correctCheckBox_clicked()
{
  if(correctCheckBox->isChecked())
  {
    sizeGapsSpinBox->setEnabled(true);
    sizeSegmentsSpinBox->setEnabled(true);
    orderComboBox->setEnabled(true);
    lddGridComboBox->setEnabled(true);
  }
  else
  {
    sizeGapsSpinBox->setEnabled(false);
    sizeSegmentsSpinBox->setEnabled(false);
    orderComboBox->setEnabled(false);
    lddGridComboBox->setEnabled(false);
  }
}
