#include <HidroOverlayRule.h>

HidroOverlayRule::HidroOverlayRule(const std::string& ruleId): _ruleId(ruleId), _layer(NULL), _attr(NULL)
{
}

HidroOverlayRule::~HidroOverlayRule()
{
	if(_attr)
	{
		delete _attr;
	}
}

void HidroOverlayRule::setRuleId(const std::string& ruleId)
{
	_ruleId = ruleId;
}

std::string HidroOverlayRule::getRuleId()
{
	return _ruleId;
}

void HidroOverlayRule::setLayer(TeLayer* layer)
{
	_layer = layer;
}

TeLayer* HidroOverlayRule::getLayer()
{
	return _layer;
}

void HidroOverlayRule::setComparisonOperator(const OverlayComparisonOperator& op)
{
	_op = op;
}

HidroOverlayRule::OverlayComparisonOperator HidroOverlayRule::getComparisonOperator()
{
	return _op;
}

void HidroOverlayRule::setRuleAttr(HidroAttr* attr)
{
	_attr = attr;
}

HidroAttr* HidroOverlayRule::getRuleAttr()
{
	return _attr;
}

HidroOverlayRule::OverlayComparisonOperator HidroOverlayRule::getRuleComparisonOp(const std::string& value)
{
	if(value == "==")
	{
		return HidroOverlayRule::Equal;
	}
	else if(value == "<>")
	{
		return HidroOverlayRule::NotEqual;
	}
	else if(value == ">")
	{
		return HidroOverlayRule::GreaterThan;
	}
	else if(value == "<")
	{
		return HidroOverlayRule::LessThan;
	}
	else if(value == ">=")
	{
		return HidroOverlayRule::GreaterThanOrEqualTo;
	}
	else if(value == "<=")
	{
		return HidroOverlayRule::LessThanOrEqualTo;
	}

	return HidroOverlayRule::None;
}

std::string HidroOverlayRule::getRuleStrComparisonOp(const OverlayComparisonOperator& op)
{
	if(op == HidroOverlayRule::Equal)
	{
		return "==";
	}
	else if(op == HidroOverlayRule::NotEqual)
	{
		return "<>";
	}
	else if(op == HidroOverlayRule::GreaterThan)
	{
		return ">";
	}
	else if(op == HidroOverlayRule::LessThan)
	{
		return "<";
	}
	else if(op == HidroOverlayRule::GreaterThanOrEqualTo)
	{
		return ">=";
	}
	else if(op == HidroOverlayRule::LessThanOrEqualTo)
	{
		return "<=";
	}

	return "";
}