#ifndef HIDRO_DEM_FILL_H
#define HIDRO_DEM_FILL_H

#include <HidroFlowAlgorithm.h>

class TeRaster;

class HidroDEMFill : public HidroFlowAlgorithm
{
public:
  /**
   * @name Constructor and Destructor Methods.
	 *  Methods related to instantiation and destruction.
	**/
	//@{
  
    /**
    * \brief Constructor with parameters.
	  * \param lddRaster LDD raster (input).
    * \param demRaster DEM raster (input).    
    * \param outputDEMRaster output DEM raster (result).    
	  **/
    HidroDEMFill( TeRaster* inputDEMRaster,
    TeRaster* referenceDEMRaster,    
    TeRaster* &outputDEMRaster );

    ~HidroDEMFill();

  bool execute();

protected:
  bool cancel();

  TeRaster* inputDEMRaster_;
  TeRaster* referenceDEMRaster_;
  TeRaster* &outputDEMRaster_;  
};

#endif